/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint;

import java.io.IOException;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.dispatcher.ExecutionGraphInfoStore;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.runtime.entrypoint.component.DefaultDispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.resourcemanager.ResourceManagerFactory;
import org.apache.flink.runtime.resourcemanager.StandaloneResourceManagerFactory;
import org.apache.flink.runtime.testutils.TestJvmProcess;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class ClusterUncaughtExceptionHandlerITCase
extends TestLogger {
    @Before
    public void ensureSupportedOS() {
        Assume.assumeTrue((OperatingSystem.isLinux() || OperatingSystem.isMac() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExitDueToUncaughtException() throws Exception {
        ForcedJVMExitProcess testProcess = new ForcedJVMExitProcess(ClusterTestingEntrypoint.class);
        boolean success = false;
        testProcess.startProcess();
        try {
            testProcess.waitFor();
            int signedIntegerExitCode = -17;
            int unsignedIntegerExitCode = (byte)signedIntegerExitCode & 0xFF;
            Assert.assertThat((Object)testProcess.exitCode(), (Matcher)CoreMatchers.is((Object)unsignedIntegerExitCode));
            success = true;
        }
        finally {
            if (!success) {
                testProcess.printProcessLog();
            }
            testProcess.destroy();
        }
    }

    private static final class ForcedJVMExitProcess
    extends TestJvmProcess {
        private final Class<?> entryPointName;

        private ForcedJVMExitProcess(Class<?> entryPointName) throws Exception {
            this.entryPointName = entryPointName;
        }

        @Override
        public String getName() {
            return this.getEntryPointClassName();
        }

        @Override
        public String[] getJvmArgs() {
            return new String[0];
        }

        @Override
        public String getEntryPointClassName() {
            return this.entryPointName.getName();
        }
    }

    private static class ClusterTestingEntrypoint
    extends ClusterEntrypoint {
        protected ClusterTestingEntrypoint(Configuration configuration) {
            super(configuration);
        }

        protected DispatcherResourceManagerComponentFactory createDispatcherResourceManagerComponentFactory(Configuration configuration) throws IOException {
            Thread t = new Thread(() -> {
                throw new RuntimeException("Test exception");
            });
            t.start();
            return DefaultDispatcherResourceManagerComponentFactory.createSessionComponentFactory((ResourceManagerFactory)StandaloneResourceManagerFactory.getInstance());
        }

        protected ExecutionGraphInfoStore createSerializableExecutionGraphStore(Configuration configuration, ScheduledExecutor scheduledExecutor) throws IOException {
            return null;
        }

        public static void main(String[] args) {
            try {
                Configuration config = new Configuration();
                config.set(ClusterOptions.UNCAUGHT_EXCEPTION_HANDLING, (Object)ClusterOptions.UncaughtExceptionHandleMode.FAIL);
                ClusterTestingEntrypoint testingEntrypoint = new ClusterTestingEntrypoint(config);
                testingEntrypoint.startCluster();
            }
            catch (Throwable t) {
                System.exit(1);
            }
        }
    }
}

