/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.dispatcher.DefaultJobManagerRunnerRegistry;
import org.apache.flink.runtime.dispatcher.Dispatcher;
import org.apache.flink.runtime.dispatcher.DispatcherBootstrapFactory;
import org.apache.flink.runtime.dispatcher.DispatcherId;
import org.apache.flink.runtime.dispatcher.DispatcherOperationCaches;
import org.apache.flink.runtime.dispatcher.DispatcherServices;
import org.apache.flink.runtime.dispatcher.ExecutionGraphInfoStore;
import org.apache.flink.runtime.dispatcher.HistoryServerArchivist;
import org.apache.flink.runtime.dispatcher.JobManagerRunnerFactory;
import org.apache.flink.runtime.dispatcher.JobManagerRunnerRegistry;
import org.apache.flink.runtime.dispatcher.MemoryExecutionGraphInfoStore;
import org.apache.flink.runtime.dispatcher.NoOpDispatcherBootstrap;
import org.apache.flink.runtime.dispatcher.NoOpJobGraphWriter;
import org.apache.flink.runtime.dispatcher.TestingJobMasterServiceLeadershipRunnerFactory;
import org.apache.flink.runtime.dispatcher.VoidHistoryServerArchivist;
import org.apache.flink.runtime.dispatcher.cleanup.CleanupRunnerFactory;
import org.apache.flink.runtime.dispatcher.cleanup.DispatcherResourceCleanerFactory;
import org.apache.flink.runtime.dispatcher.cleanup.ResourceCleanerFactory;
import org.apache.flink.runtime.dispatcher.cleanup.TestingCleanupRunnerFactory;
import org.apache.flink.runtime.dispatcher.cleanup.TestingRetryStrategies;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedJobResultStore;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.JobGraphWriter;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TimeUtils;

class TestingDispatcher
extends Dispatcher {
    private final CompletableFuture<Void> startFuture = new CompletableFuture();

    private TestingDispatcher(RpcService rpcService, DispatcherId fencingToken, Collection<JobGraph> recoveredJobs, Collection<JobResult> recoveredDirtyJobs, Configuration configuration, HighAvailabilityServices highAvailabilityServices, GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever, HeartbeatServices heartbeatServices, BlobServer blobServer, FatalErrorHandler fatalErrorHandler, JobGraphWriter jobGraphWriter, JobResultStore jobResultStore, JobManagerMetricGroup jobManagerMetricGroup, @Nullable String metricServiceQueryAddress, Executor ioExecutor, HistoryServerArchivist historyServerArchivist, ExecutionGraphInfoStore executionGraphInfoStore, JobManagerRunnerFactory jobManagerRunnerFactory, CleanupRunnerFactory cleanupRunnerFactory, DispatcherBootstrapFactory dispatcherBootstrapFactory, DispatcherOperationCaches dispatcherOperationCaches, JobManagerRunnerRegistry jobManagerRunnerRegistry, ResourceCleanerFactory resourceCleanerFactory) throws Exception {
        super(rpcService, fencingToken, recoveredJobs, recoveredDirtyJobs, dispatcherBootstrapFactory, new DispatcherServices(configuration, highAvailabilityServices, resourceManagerGatewayRetriever, blobServer, heartbeatServices, executionGraphInfoStore, fatalErrorHandler, historyServerArchivist, metricServiceQueryAddress, dispatcherOperationCaches, jobManagerMetricGroup, jobGraphWriter, jobResultStore, jobManagerRunnerFactory, cleanupRunnerFactory, ioExecutor), jobManagerRunnerRegistry, resourceCleanerFactory);
    }

    public void onStart() throws Exception {
        try {
            super.onStart();
        }
        catch (Exception e) {
            this.startFuture.completeExceptionally(e);
            throw e;
        }
        this.startFuture.complete(null);
    }

    void completeJobExecution(ExecutionGraphInfo executionGraphInfo) {
        this.runAsync(() -> {
            try {
                this.jobReachedTerminalState(executionGraphInfo);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    <T> CompletableFuture<T> callAsyncInMainThread(Callable<CompletableFuture<T>> callable) {
        return this.callAsync(callable, TestingUtils.TESTING_DURATION).thenCompose(Function.identity());
    }

    CompletableFuture<Void> getJobTerminationFuture(@Nonnull JobID jobId, @Nonnull Time timeout) {
        return this.callAsync(() -> this.getJobTerminationFuture(jobId), TimeUtils.toDuration((Time)timeout)).thenCompose(Function.identity());
    }

    CompletableFuture<Integer> getNumberJobs(Time timeout) {
        return this.callAsync(() -> ((Collection)this.listJobs(timeout).get()).size(), TimeUtils.toDuration((Time)timeout));
    }

    void waitUntilStarted() {
        this.startFuture.join();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private DispatcherId fencingToken = DispatcherId.generate();
        private Collection<JobGraph> recoveredJobs = Collections.emptyList();
        @Nullable
        private Collection<JobResult> recoveredDirtyJobs = null;
        private HighAvailabilityServices highAvailabilityServices = new TestingHighAvailabilityServices();
        private TestingResourceManagerGateway resourceManagerGateway = new TestingResourceManagerGateway();
        private GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever = () -> CompletableFuture.completedFuture(this.resourceManagerGateway);
        private HeartbeatServices heartbeatServices = new HeartbeatServices(1000L, 1000L);
        private JobGraphWriter jobGraphWriter = NoOpJobGraphWriter.INSTANCE;
        private JobResultStore jobResultStore = new EmbeddedJobResultStore();
        private Configuration configuration = new Configuration();
        @Nullable
        private BlobServer blobServer = null;
        private FatalErrorHandler fatalErrorHandler = new TestingFatalErrorHandler();
        private JobManagerMetricGroup jobManagerMetricGroup = UnregisteredMetricGroups.createUnregisteredJobManagerMetricGroup();
        @Nullable
        private String metricServiceQueryAddress = null;
        private Executor ioExecutor = ForkJoinPool.commonPool();
        private HistoryServerArchivist historyServerArchivist = VoidHistoryServerArchivist.INSTANCE;
        private ExecutionGraphInfoStore executionGraphInfoStore = new MemoryExecutionGraphInfoStore();
        private JobManagerRunnerFactory jobManagerRunnerFactory = new TestingJobMasterServiceLeadershipRunnerFactory();
        private CleanupRunnerFactory cleanupRunnerFactory = new TestingCleanupRunnerFactory();
        private DispatcherBootstrapFactory dispatcherBootstrapFactory = (dispatcher, scheduledExecutor, errorHandler) -> new NoOpDispatcherBootstrap();
        private DispatcherOperationCaches dispatcherOperationCaches = new DispatcherOperationCaches();
        private JobManagerRunnerRegistry jobManagerRunnerRegistry = new DefaultJobManagerRunnerRegistry(1);
        @Nullable
        private ResourceCleanerFactory resourceCleanerFactory;

        public Builder setFencingToken(DispatcherId fencingToken) {
            this.fencingToken = fencingToken;
            return this;
        }

        public Builder setRecoveredJobs(Collection<JobGraph> recoveredJobs) {
            this.recoveredJobs = recoveredJobs;
            return this;
        }

        public Builder setRecoveredDirtyJobs(@Nullable Collection<JobResult> recoveredDirtyJobs) {
            this.recoveredDirtyJobs = recoveredDirtyJobs;
            return this;
        }

        public Builder setHighAvailabilityServices(HighAvailabilityServices highAvailabilityServices) {
            this.highAvailabilityServices = highAvailabilityServices;
            return this;
        }

        public Builder setResourceManagerGateway(TestingResourceManagerGateway resourceManagerGateway) {
            this.resourceManagerGateway = resourceManagerGateway;
            return this;
        }

        public Builder setResourceManagerGatewayRetriever(GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever) {
            this.resourceManagerGatewayRetriever = resourceManagerGatewayRetriever;
            return this;
        }

        public Builder setHeartbeatServices(HeartbeatServices heartbeatServices) {
            this.heartbeatServices = heartbeatServices;
            return this;
        }

        public Builder setJobGraphWriter(JobGraphWriter jobGraphWriter) {
            this.jobGraphWriter = jobGraphWriter;
            return this;
        }

        public Builder setJobResultStore(JobResultStore jobResultStore) {
            this.jobResultStore = jobResultStore;
            return this;
        }

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder setBlobServer(BlobServer blobServer) {
            this.blobServer = blobServer;
            return this;
        }

        public Builder setFatalErrorHandler(FatalErrorHandler fatalErrorHandler) {
            this.fatalErrorHandler = fatalErrorHandler;
            return this;
        }

        public Builder setJobManagerMetricGroup(JobManagerMetricGroup jobManagerMetricGroup) {
            this.jobManagerMetricGroup = jobManagerMetricGroup;
            return this;
        }

        public Builder setMetricServiceQueryAddress(@Nullable String metricServiceQueryAddress) {
            this.metricServiceQueryAddress = metricServiceQueryAddress;
            return this;
        }

        public Builder setIoExecutor(Executor ioExecutor) {
            this.ioExecutor = ioExecutor;
            return this;
        }

        public Builder setHistoryServerArchivist(HistoryServerArchivist historyServerArchivist) {
            this.historyServerArchivist = historyServerArchivist;
            return this;
        }

        public Builder setExecutionGraphInfoStore(ExecutionGraphInfoStore executionGraphInfoStore) {
            this.executionGraphInfoStore = executionGraphInfoStore;
            return this;
        }

        public Builder setJobManagerRunnerFactory(JobManagerRunnerFactory jobManagerRunnerFactory) {
            this.jobManagerRunnerFactory = jobManagerRunnerFactory;
            return this;
        }

        public Builder setCleanupRunnerFactory(CleanupRunnerFactory cleanupRunnerFactory) {
            this.cleanupRunnerFactory = cleanupRunnerFactory;
            return this;
        }

        public Builder setDispatcherBootstrapFactory(DispatcherBootstrapFactory dispatcherBootstrapFactory) {
            this.dispatcherBootstrapFactory = dispatcherBootstrapFactory;
            return this;
        }

        public Builder setDispatcherOperationCaches(DispatcherOperationCaches dispatcherOperationCaches) {
            this.dispatcherOperationCaches = dispatcherOperationCaches;
            return this;
        }

        public Builder setJobManagerRunnerRegistry(JobManagerRunnerRegistry jobManagerRunnerRegistry) {
            this.jobManagerRunnerRegistry = jobManagerRunnerRegistry;
            return this;
        }

        public Builder setResourceCleanerFactory(ResourceCleanerFactory resourceCleanerFactory) {
            this.resourceCleanerFactory = resourceCleanerFactory;
            return this;
        }

        private ResourceCleanerFactory createDefaultResourceCleanerFactory() {
            return new DispatcherResourceCleanerFactory(this.ioExecutor, TestingRetryStrategies.NO_RETRY_STRATEGY, this.jobManagerRunnerRegistry, this.jobGraphWriter, this.blobServer, this.highAvailabilityServices, this.jobManagerMetricGroup);
        }

        public TestingDispatcher build(RpcService rpcService) throws Exception {
            return new TestingDispatcher(rpcService, this.fencingToken, this.recoveredJobs, this.recoveredDirtyJobs == null ? this.jobResultStore.getDirtyResults() : this.recoveredDirtyJobs, this.configuration, this.highAvailabilityServices, this.resourceManagerGatewayRetriever, this.heartbeatServices, (BlobServer)Preconditions.checkNotNull((Object)this.blobServer, (String)"No BlobServer is specified for building the TestingDispatcher"), this.fatalErrorHandler, this.jobGraphWriter, this.jobResultStore, this.jobManagerMetricGroup, this.metricServiceQueryAddress, this.ioExecutor, this.historyServerArchivist, this.executionGraphInfoStore, this.jobManagerRunnerFactory, this.cleanupRunnerFactory, this.dispatcherBootstrapFactory, this.dispatcherOperationCaches, this.jobManagerRunnerRegistry, this.resourceCleanerFactory != null ? this.resourceCleanerFactory : this.createDefaultResourceCleanerFactory());
        }
    }
}

