/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;

public class IOMetrics
implements Serializable {
    private static final long serialVersionUID = -7208093607556457183L;
    protected long numRecordsIn;
    protected long numRecordsOut;
    protected long numBytesIn;
    protected long numBytesOut;
    protected final Map<IntermediateResultPartitionID, Long> numBytesProducedOfPartitions = new HashMap<IntermediateResultPartitionID, Long>();

    public IOMetrics(Meter recordsIn, Meter recordsOut, Meter bytesIn, Meter bytesOut, Map<IntermediateResultPartitionID, Counter> numBytesProducedCounters) {
        this.numRecordsIn = recordsIn.getCount();
        this.numRecordsOut = recordsOut.getCount();
        this.numBytesIn = bytesIn.getCount();
        this.numBytesOut = bytesOut.getCount();
        for (Map.Entry<IntermediateResultPartitionID, Counter> counter : numBytesProducedCounters.entrySet()) {
            this.numBytesProducedOfPartitions.put(counter.getKey(), counter.getValue().getCount());
        }
    }

    public IOMetrics(long numBytesIn, long numBytesOut, long numRecordsIn, long numRecordsOut) {
        this.numBytesIn = numBytesIn;
        this.numBytesOut = numBytesOut;
        this.numRecordsIn = numRecordsIn;
        this.numRecordsOut = numRecordsOut;
    }

    public long getNumRecordsIn() {
        return this.numRecordsIn;
    }

    public long getNumRecordsOut() {
        return this.numRecordsOut;
    }

    public long getNumBytesIn() {
        return this.numBytesIn;
    }

    public long getNumBytesOut() {
        return this.numBytesOut;
    }

    public Map<IntermediateResultPartitionID, Long> getNumBytesProducedOfPartitions() {
        return this.numBytesProducedOfPartitions;
    }
}

