/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.config.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.util.config.memory.JvmMetaspaceAndOverheadOptions;
import org.apache.flink.util.Preconditions;

public class ProcessMemoryOptions {
    private final List<ConfigOption<MemorySize>> requiredFineGrainedOptions;
    private final ConfigOption<MemorySize> totalFlinkMemoryOption;
    private final ConfigOption<MemorySize> totalProcessMemoryOption;
    private final JvmMetaspaceAndOverheadOptions jvmOptions;

    public ProcessMemoryOptions(List<ConfigOption<MemorySize>> requiredFineGrainedOptions, ConfigOption<MemorySize> totalFlinkMemoryOption, ConfigOption<MemorySize> totalProcessMemoryOption, JvmMetaspaceAndOverheadOptions jvmOptions) {
        this.requiredFineGrainedOptions = new ArrayList<ConfigOption<MemorySize>>((Collection)Preconditions.checkNotNull(requiredFineGrainedOptions));
        this.totalFlinkMemoryOption = (ConfigOption)Preconditions.checkNotNull(totalFlinkMemoryOption);
        this.totalProcessMemoryOption = (ConfigOption)Preconditions.checkNotNull(totalProcessMemoryOption);
        this.jvmOptions = (JvmMetaspaceAndOverheadOptions)Preconditions.checkNotNull((Object)jvmOptions);
    }

    List<ConfigOption<MemorySize>> getRequiredFineGrainedOptions() {
        return Collections.unmodifiableList(this.requiredFineGrainedOptions);
    }

    ConfigOption<MemorySize> getTotalFlinkMemoryOption() {
        return this.totalFlinkMemoryOption;
    }

    ConfigOption<MemorySize> getTotalProcessMemoryOption() {
        return this.totalProcessMemoryOption;
    }

    JvmMetaspaceAndOverheadOptions getJvmOptions() {
        return this.jvmOptions;
    }
}

