/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.scheduler.ExecutionVertexOperations;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

public class TestExecutionVertexOperationsDecorator
implements ExecutionVertexOperations {
    private final ExecutionVertexOperations delegate;
    private final CountLatch deployedVertices = new CountLatch();
    private final CountLatch canceledVertices = new CountLatch();
    private final CountLatch failedVertices = new CountLatch();
    private boolean failDeploy;

    public TestExecutionVertexOperationsDecorator(ExecutionVertexOperations delegate) {
        this.delegate = (ExecutionVertexOperations)Preconditions.checkNotNull((Object)delegate);
    }

    public void deploy(ExecutionVertex executionVertex) throws JobException {
        this.deployedVertices.add(executionVertex.getID());
        if (this.failDeploy) {
            throw new RuntimeException("Expected");
        }
        this.delegate.deploy(executionVertex);
    }

    public CompletableFuture<?> cancel(ExecutionVertex executionVertex) {
        this.canceledVertices.add(executionVertex.getID());
        return this.delegate.cancel(executionVertex);
    }

    public void markFailed(ExecutionVertex executionVertex, Throwable cause) {
        this.failedVertices.add(executionVertex.getID());
        this.delegate.markFailed(executionVertex, cause);
    }

    public void enableFailDeploy() {
        this.failDeploy = true;
    }

    public void disableFailDeploy() {
        this.failDeploy = false;
    }

    public List<ExecutionVertexID> getDeployedVertices() {
        return this.deployedVertices.getVertices();
    }

    public List<ExecutionVertexID> getCanceledVertices() {
        return this.canceledVertices.getVertices();
    }

    public List<ExecutionVertexID> getFailedVertices() {
        return this.failedVertices.getVertices();
    }

    public void awaitCanceledVertices(int count) throws InterruptedException {
        this.canceledVertices.await(count);
    }

    public void awaitFailedVertices(int count) throws InterruptedException {
        this.failedVertices.await(count);
    }

    private static class CountLatch {
        @GuardedBy(value="lock")
        private final List<ExecutionVertexID> vertices = new ArrayList<ExecutionVertexID>();
        private final Object lock = new Object();

        private CountLatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(ExecutionVertexID executionVertexId) {
            Object object = this.lock;
            synchronized (object) {
                this.vertices.add(executionVertexId);
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await(int count) throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                while (this.vertices.size() < count) {
                    this.lock.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ExecutionVertexID> getVertices() {
            Object object = this.lock;
            synchronized (object) {
                return Collections.unmodifiableList(this.vertices);
            }
        }
    }
}

