/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.checkpoint;

import java.io.File;
import java.net.URLClassLoader;
import java.util.Optional;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.messages.checkpoint.DeclineCheckpoint;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DeclineCheckpointTest
extends TestLogger {
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();

    @Test
    public void testDeclineCheckpointWithUserExceptionCanBeDeserializedWithoutUserClass() throws Exception {
        String className = "UserException";
        URLClassLoader userClassLoader = ClassLoaderUtils.compileAndLoadJava((File)TEMPORARY_FOLDER.newFolder(), (String)"UserException.java", (String)String.format("public class %s extends RuntimeException { public %s() {super(\"UserMessage\");} }", "UserException", "UserException"));
        Throwable userException = (Throwable)Class.forName("UserException", false, userClassLoader).newInstance();
        CheckpointException checkpointException = new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED, userException);
        byte[] serializedCheckpointMessage = InstantiationUtil.serializeObject((Object)new DeclineCheckpoint(new JobID(), new ExecutionAttemptID(), 1L, checkpointException));
        DeclineCheckpoint deserializedCheckpointMessage = (DeclineCheckpoint)InstantiationUtil.deserializeObject((byte[])serializedCheckpointMessage, (ClassLoader)ClassLoader.getSystemClassLoader());
        CheckpointException throwable = deserializedCheckpointMessage.getSerializedCheckpointException().unwrap();
        MatcherAssert.assertThat((Object)((Object)throwable), (Matcher)Matchers.instanceOf(CheckpointException.class));
        Optional throwableWithMessage = ExceptionUtils.findThrowableWithMessage((Throwable)throwable, (String)userException.getMessage());
        Assert.assertTrue((boolean)throwableWithMessage.isPresent());
        MatcherAssert.assertThat((Object)((Throwable)throwableWithMessage.get()).getMessage(), (Matcher)Matchers.equalTo((Object)userException.getMessage()));
    }
}

