/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Deadline;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.dispatcher.DispatcherBootstrapFactory;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.dispatcher.DispatcherId;
import org.apache.flink.runtime.dispatcher.DispatcherServices;
import org.apache.flink.runtime.dispatcher.ExecutionGraphInfoStore;
import org.apache.flink.runtime.dispatcher.HistoryServerArchivist;
import org.apache.flink.runtime.dispatcher.JobManagerRunnerFactory;
import org.apache.flink.runtime.dispatcher.JobMasterServiceLeadershipRunnerFactory;
import org.apache.flink.runtime.dispatcher.MemoryExecutionGraphInfoStore;
import org.apache.flink.runtime.dispatcher.NoOpDispatcherBootstrap;
import org.apache.flink.runtime.dispatcher.NoOpJobGraphWriter;
import org.apache.flink.runtime.dispatcher.TestingDispatcher;
import org.apache.flink.runtime.dispatcher.VoidHistoryServerArchivist;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.jobmanager.JobGraphWriter;
import org.apache.flink.runtime.jobmanager.StandaloneJobGraphStore;
import org.apache.flink.runtime.leaderretrieval.SettableLeaderRetrievalService;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.runtime.util.TestingFatalErrorHandlerResource;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.TimeUtils;
import org.apache.flink.util.function.SupplierWithException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;

public class AbstractDispatcherTest
extends TestLogger {
    static TestingRpcService rpcService;
    static final Time TIMEOUT;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public final TestingFatalErrorHandlerResource testingFatalErrorHandlerResource = new TestingFatalErrorHandlerResource();
    @Rule
    public TestName name = new TestName();
    Configuration configuration;
    BlobServer blobServer;
    TestingHighAvailabilityServices haServices;
    HeartbeatServices heartbeatServices;

    @BeforeClass
    public static void setupClass() {
        rpcService = new TestingRpcService();
    }

    @AfterClass
    public static void teardownClass() throws Exception {
        if (rpcService != null) {
            RpcUtils.terminateRpcService((RpcService)rpcService, (Time)TIMEOUT);
            rpcService = null;
        }
    }

    static void awaitStatus(DispatcherGateway dispatcherGateway, JobID jobId, JobStatus status) throws Exception {
        CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> status.equals(dispatcherGateway.requestJobStatus(jobId, TIMEOUT).get())), Deadline.fromNow((Duration)TimeUtils.toDuration((Time)TIMEOUT)));
    }

    @Before
    public void setUp() throws Exception {
        this.heartbeatServices = new HeartbeatServices(1000L, 10000L);
        this.haServices = new TestingHighAvailabilityServices();
        this.haServices.setCheckpointRecoveryFactory((CheckpointRecoveryFactory)new StandaloneCheckpointRecoveryFactory());
        this.haServices.setResourceManagerLeaderRetriever(new SettableLeaderRetrievalService());
        this.haServices.setJobGraphStore((JobGraphStore)new StandaloneJobGraphStore());
        this.configuration = new Configuration();
        this.configuration.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        this.blobServer = new BlobServer(this.configuration, (BlobStore)new VoidBlobStore());
    }

    @After
    public void tearDown() throws Exception {
        if (this.haServices != null) {
            this.haServices.closeAndCleanupAllData();
        }
        if (this.blobServer != null) {
            this.blobServer.close();
        }
    }

    static {
        TIMEOUT = Time.minutes((long)1L);
    }

    public class TestingDispatcherBuilder {
        private Collection<JobGraph> initialJobGraphs = Collections.emptyList();
        private final DispatcherBootstrapFactory dispatcherBootstrapFactory = (dispatcher, scheduledExecutor, errorHandler) -> new NoOpDispatcherBootstrap();
        private HeartbeatServices heartbeatServices;
        private HighAvailabilityServices haServices;
        private JobManagerRunnerFactory jobManagerRunnerFactory;
        private JobGraphWriter jobGraphWriter;
        private FatalErrorHandler fatalErrorHandler;
        private HistoryServerArchivist historyServerArchivist;

        public TestingDispatcherBuilder() {
            this.heartbeatServices = AbstractDispatcherTest.this.heartbeatServices;
            this.haServices = AbstractDispatcherTest.this.haServices;
            this.jobManagerRunnerFactory = JobMasterServiceLeadershipRunnerFactory.INSTANCE;
            this.jobGraphWriter = NoOpJobGraphWriter.INSTANCE;
            this.fatalErrorHandler = AbstractDispatcherTest.this.testingFatalErrorHandlerResource.getFatalErrorHandler();
            this.historyServerArchivist = VoidHistoryServerArchivist.INSTANCE;
        }

        TestingDispatcherBuilder setHeartbeatServices(HeartbeatServices heartbeatServices) {
            this.heartbeatServices = heartbeatServices;
            return this;
        }

        TestingDispatcherBuilder setHaServices(HighAvailabilityServices haServices) {
            this.haServices = haServices;
            return this;
        }

        TestingDispatcherBuilder setInitialJobGraphs(Collection<JobGraph> initialJobGraphs) {
            this.initialJobGraphs = initialJobGraphs;
            return this;
        }

        TestingDispatcherBuilder setJobManagerRunnerFactory(JobManagerRunnerFactory jobManagerRunnerFactory) {
            this.jobManagerRunnerFactory = jobManagerRunnerFactory;
            return this;
        }

        TestingDispatcherBuilder setJobGraphWriter(JobGraphWriter jobGraphWriter) {
            this.jobGraphWriter = jobGraphWriter;
            return this;
        }

        public TestingDispatcherBuilder setFatalErrorHandler(FatalErrorHandler fatalErrorHandler) {
            this.fatalErrorHandler = fatalErrorHandler;
            return this;
        }

        public TestingDispatcherBuilder setHistoryServerArchivist(HistoryServerArchivist historyServerArchivist) {
            this.historyServerArchivist = historyServerArchivist;
            return this;
        }

        TestingDispatcher build() throws Exception {
            TestingResourceManagerGateway resourceManagerGateway = new TestingResourceManagerGateway();
            MemoryExecutionGraphInfoStore executionGraphInfoStore = new MemoryExecutionGraphInfoStore();
            return new TestingDispatcher(rpcService, DispatcherId.generate(), this.initialJobGraphs, this.dispatcherBootstrapFactory, new DispatcherServices(AbstractDispatcherTest.this.configuration, this.haServices, () -> CompletableFuture.completedFuture(resourceManagerGateway), AbstractDispatcherTest.this.blobServer, this.heartbeatServices, (ExecutionGraphInfoStore)executionGraphInfoStore, this.fatalErrorHandler, this.historyServerArchivist, null, UnregisteredMetricGroups.createUnregisteredJobManagerMetricGroup(), this.jobGraphWriter, this.jobManagerRunnerFactory, (Executor)ForkJoinPool.commonPool()));
        }
    }
}

