/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.blob.BlobClientTest;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobKeyTest;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerPutTest;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.FutureUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class BlobServerGetTest
extends TestLogger {
    private final Random rnd = new Random();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Test
    public void testGetTransientFailsDuringLookup1() throws IOException {
        this.testGetFailsDuringLookup(null, new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testGetTransientFailsDuringLookup2() throws IOException {
        this.testGetFailsDuringLookup(new JobID(), new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testGetTransientFailsDuringLookup3() throws IOException {
        this.testGetFailsDuringLookup(new JobID(), null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testGetPermanentFailsDuringLookup() throws IOException {
        this.testGetFailsDuringLookup(new JobID(), new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
    }

    private void testGetFailsDuringLookup(@Nullable JobID jobId1, @Nullable JobID jobId2, BlobKey.BlobType blobType) throws IOException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());){
            server.start();
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            BlobKey key = BlobServerPutTest.put((BlobService)server, jobId1, data, blobType);
            Assert.assertNotNull((Object)key);
            File blobFile = server.getStorageLocation(jobId1, key);
            Assert.assertTrue((boolean)blobFile.delete());
            BlobServerGetTest.verifyDeleted((BlobService)server, jobId1, key);
            BlobKey key2 = BlobServerPutTest.put((BlobService)server, jobId2, data, blobType);
            Assert.assertNotNull((Object)key2);
            BlobKeyTest.verifyKeyDifferentHashEquals(key, key2);
            BlobServerGetTest.get((BlobService)server, jobId2, key2);
            BlobServerGetTest.verifyDeleted((BlobService)server, jobId1, key);
            blobFile = server.getStorageLocation(jobId2, key2);
            Assert.assertTrue((boolean)blobFile.delete());
            BlobServerGetTest.verifyDeleted((BlobService)server, jobId2, key2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFailsIncomingForJobHa() throws IOException {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        JobID jobId = new JobID();
        Configuration config = new Configuration();
        config.setString(HighAvailabilityOptions.HA_MODE, "ZOOKEEPER");
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        config.setString(HighAvailabilityOptions.HA_STORAGE_PATH, this.temporaryFolder.newFolder().getPath());
        BlobStoreService blobStore = null;
        try {
            blobStore = BlobUtils.createBlobStoreFromConfig((Configuration)config);
            File tempFileDir = null;
            try (BlobServer server = new BlobServer(config, (BlobStore)blobStore);){
                server.start();
                byte[] data = new byte[2000000];
                this.rnd.nextBytes(data);
                BlobKey blobKey = BlobServerPutTest.put((BlobService)server, jobId, data, BlobKey.BlobType.PERMANENT_BLOB);
                Assert.assertTrue((boolean)server.getStorageLocation(jobId, blobKey).delete());
                tempFileDir = server.createTemporaryFilename().getParentFile();
                Assert.assertTrue((boolean)tempFileDir.setExecutable(true, false));
                Assert.assertTrue((boolean)tempFileDir.setReadable(true, false));
                Assert.assertTrue((boolean)tempFileDir.setWritable(false, false));
                this.exception.expect(IOException.class);
                this.exception.expectMessage("Permission denied");
                try {
                    BlobServerGetTest.get((BlobService)server, jobId, blobKey);
                }
                finally {
                    HashSet<String> expectedDirs = new HashSet<String>();
                    expectedDirs.add("incoming");
                    expectedDirs.add("job_" + jobId);
                    File storageDir = tempFileDir.getParentFile();
                    String[] actualDirs = storageDir.list();
                    Assert.assertNotNull((Object)actualDirs);
                    Assert.assertEquals(expectedDirs, new HashSet<String>(Arrays.asList(actualDirs)));
                    File jobDir = new File(tempFileDir.getParentFile(), "job_" + jobId);
                    Assert.assertArrayEquals((Object[])new String[0], (Object[])jobDir.list());
                }
            }
            finally {
                if (tempFileDir != null) {
                    tempFileDir.setWritable(true, false);
                }
            }
        }
        finally {
            if (blobStore != null) {
                blobStore.closeAndCleanupAllData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFailsStoreForJobHa() throws IOException {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        JobID jobId = new JobID();
        Configuration config = new Configuration();
        config.setString(HighAvailabilityOptions.HA_MODE, "ZOOKEEPER");
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        config.setString(HighAvailabilityOptions.HA_STORAGE_PATH, this.temporaryFolder.newFolder().getPath());
        BlobStoreService blobStore = null;
        try {
            blobStore = BlobUtils.createBlobStoreFromConfig((Configuration)config);
            File jobStoreDir = null;
            try (BlobServer server = new BlobServer(config, (BlobStore)blobStore);){
                server.start();
                byte[] data = new byte[2000000];
                this.rnd.nextBytes(data);
                BlobKey blobKey = BlobServerPutTest.put((BlobService)server, jobId, data, BlobKey.BlobType.PERMANENT_BLOB);
                Assert.assertTrue((boolean)server.getStorageLocation(jobId, blobKey).delete());
                jobStoreDir = server.getStorageLocation(jobId, blobKey).getParentFile();
                Assert.assertTrue((boolean)jobStoreDir.setExecutable(true, false));
                Assert.assertTrue((boolean)jobStoreDir.setReadable(true, false));
                Assert.assertTrue((boolean)jobStoreDir.setWritable(false, false));
                this.exception.expect(AccessDeniedException.class);
                try {
                    BlobServerGetTest.get((BlobService)server, jobId, blobKey);
                }
                finally {
                    File incomingFileDir = new File(jobStoreDir.getParent(), "incoming");
                    Assert.assertArrayEquals((Object[])new String[0], (Object[])incomingFileDir.list());
                    Assert.assertArrayEquals((Object[])new String[0], (Object[])jobStoreDir.list());
                }
            }
            finally {
                if (jobStoreDir != null) {
                    jobStoreDir.setWritable(true, false);
                }
            }
        }
        finally {
            if (blobStore != null) {
                blobStore.closeAndCleanupAllData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFailsHaStoreForJobHa() throws IOException {
        JobID jobId = new JobID();
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());){
            server.start();
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            BlobKey blobKey = BlobServerPutTest.put((BlobService)server, jobId, data, BlobKey.BlobType.PERMANENT_BLOB);
            Assert.assertTrue((boolean)server.getStorageLocation(jobId, blobKey).delete());
            File tempFileDir = server.createTemporaryFilename().getParentFile();
            this.exception.expect(NoSuchFileException.class);
            try {
                BlobServerGetTest.get((BlobService)server, jobId, blobKey);
            }
            finally {
                HashSet<String> expectedDirs = new HashSet<String>();
                expectedDirs.add("incoming");
                expectedDirs.add("job_" + jobId);
                File storageDir = tempFileDir.getParentFile();
                String[] actualDirs = storageDir.list();
                Assert.assertNotNull((Object)actualDirs);
                Assert.assertEquals(expectedDirs, new HashSet<String>(Arrays.asList(actualDirs)));
                File jobDir = new File(tempFileDir.getParentFile(), "job_" + jobId);
                Assert.assertArrayEquals((Object[])new String[0], (Object[])jobDir.list());
            }
        }
    }

    @Test
    public void testConcurrentGetOperationsNoJob() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentGetOperations(null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testConcurrentGetOperationsForJob() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentGetOperations(new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testConcurrentGetOperationsForJobHa() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentGetOperations(new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentGetOperations(@Nullable JobID jobId, BlobKey.BlobType blobType) throws IOException, InterruptedException, ExecutionException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        BlobStore blobStore = (BlobStore)Mockito.mock(BlobStore.class);
        int numberConcurrentGetOperations = 3;
        ArrayList<CompletableFuture<File>> getOperations = new ArrayList<CompletableFuture<File>>(3);
        final byte[] data = new byte[]{1, 2, 3, 4, 99, 42};
        ((BlobStore)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                File targetFile = (File)invocation.getArguments()[2];
                FileUtils.writeByteArrayToFile((File)targetFile, (byte[])data);
                return null;
            }
        }).when((Object)blobStore)).get((JobID)Matchers.any(JobID.class), (BlobKey)Matchers.any(BlobKey.class), (File)Matchers.any(File.class));
        ExecutorService executor = Executors.newFixedThreadPool(3);
        try (BlobServer server = new BlobServer(config, blobStore);){
            server.start();
            BlobKey blobKey = BlobServerPutTest.put((BlobService)server, jobId, data, blobType);
            if (blobType == BlobKey.BlobType.PERMANENT_BLOB) {
                Assert.assertTrue((boolean)server.getStorageLocation(jobId, blobKey).delete());
            }
            for (int i = 0; i < 3; ++i) {
                CompletableFuture<File> getOperation = CompletableFuture.supplyAsync(() -> {
                    try {
                        File file = BlobServerGetTest.get((BlobService)server, jobId, blobKey);
                        BlobClientTest.validateGetAndClose((InputStream)new FileInputStream(file), data);
                        return file;
                    }
                    catch (IOException e) {
                        throw new CompletionException((Throwable)new FlinkException("Could not read blob for key " + blobKey + '.', (Throwable)e));
                    }
                }, executor);
                getOperations.add(getOperation);
            }
            FutureUtils.ConjunctFuture filesFuture = FutureUtils.combineAll(getOperations);
            filesFuture.get();
        }
        finally {
            executor.shutdownNow();
        }
    }

    static File get(BlobService service, @Nullable JobID jobId, BlobKey key) throws IOException {
        if (key instanceof PermanentBlobKey) {
            return service.getPermanentBlobService().getFile(jobId, (PermanentBlobKey)key);
        }
        if (jobId == null) {
            return service.getTransientBlobService().getFile((TransientBlobKey)key);
        }
        return service.getTransientBlobService().getFile(jobId, (TransientBlobKey)key);
    }

    static void verifyDeleted(BlobService service, @Nullable JobID jobId, BlobKey key) throws IOException {
        try {
            BlobServerGetTest.get(service, jobId, key);
            Assert.fail((String)("File " + jobId + "/" + key + " should have been deleted."));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

