/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;

public class RelativeFileStateHandle
extends FileStateHandle {
    private static final long serialVersionUID = 1L;
    private final String relativePath;

    public RelativeFileStateHandle(Path path, String relativePath, long stateSize) {
        super(path, stateSize);
        this.relativePath = relativePath;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelativeFileStateHandle)) {
            return false;
        }
        RelativeFileStateHandle other = (RelativeFileStateHandle)o;
        return super.equals(o) && this.relativePath.equals(other.relativePath);
    }

    @Override
    public int hashCode() {
        return 17 * super.hashCode() + this.relativePath.hashCode();
    }

    @Override
    public String toString() {
        return String.format("RelativeFileStateHandle State: %s, %s [%d bytes]", this.getFilePath(), this.relativePath, this.getStateSize());
    }
}

