/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.io.network.netty.SSLHandlerFactory;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.net.SSLUtils;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.BackPressureStatsTrackerImpl;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.StackTraceSampleCoordinator;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.router.Router;
import org.apache.flink.runtime.webmonitor.WebMonitor;
import org.apache.flink.runtime.webmonitor.WebMonitorConfig;
import org.apache.flink.runtime.webmonitor.WebMonitorUtils;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.LeaderGatewayRetriever;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceRetriever;
import org.apache.flink.runtime.webmonitor.utils.WebFrontendBootstrap;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.ShutdownHookUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebRuntimeMonitor
implements WebMonitor {
    public static final Time DEFAULT_REQUEST_TIMEOUT = Time.seconds((long)10L);
    private static final Logger LOG = LoggerFactory.getLogger(WebRuntimeMonitor.class);
    private final Object startupShutdownLock = new Object();
    private final LeaderRetrievalService leaderRetrievalService;
    private final LeaderGatewayRetriever<JobManagerGateway> retriever;
    private final CompletableFuture<String> localRestAddress = new CompletableFuture();
    private final Time timeout;
    private final WebFrontendBootstrap netty;
    private final File webRootDir;
    private final File uploadDir;
    private final StackTraceSampleCoordinator stackTraceSamples;
    private final BackPressureStatsTrackerImpl backPressureStatsTrackerImpl;
    private final WebMonitorConfig cfg;
    private final ExecutionGraphCache executionGraphCache;
    private final ScheduledFuture<?> executionGraphCleanupTask;
    private AtomicBoolean cleanedUp = new AtomicBoolean();
    private MetricFetcher metricFetcher;

    public WebRuntimeMonitor(Configuration config, LeaderRetrievalService leaderRetrievalService, LeaderGatewayRetriever<JobManagerGateway> jobManagerRetriever, MetricQueryServiceRetriever queryServiceRetriever, Time timeout, ScheduledExecutor scheduledExecutor) throws IOException, InterruptedException {
        SSLHandlerFactory sslFactory;
        boolean enableSSL;
        this.leaderRetrievalService = (LeaderRetrievalService)Preconditions.checkNotNull((Object)leaderRetrievalService);
        this.retriever = (LeaderGatewayRetriever)Preconditions.checkNotNull(jobManagerRetriever);
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout);
        this.cfg = new WebMonitorConfig(config);
        String configuredAddress = this.cfg.getWebFrontendAddress();
        int configuredPort = this.cfg.getWebFrontendPort();
        if (configuredPort < 0) {
            throw new IllegalArgumentException("Web frontend port is invalid: " + configuredPort);
        }
        WebMonitorUtils.LogFileLocation logFiles = WebMonitorUtils.LogFileLocation.find((Configuration)config);
        String rootDirFileName = "flink-web-" + UUID.randomUUID();
        this.webRootDir = new File(this.getBaseDir(config), rootDirFileName);
        LOG.info("Using directory {} for the web interface files", (Object)this.webRootDir);
        boolean webSubmitAllow = this.cfg.isProgramSubmitEnabled();
        if (webSubmitAllow) {
            this.uploadDir = this.getUploadDir(config);
            WebRuntimeMonitor.checkAndCreateUploadDir(this.uploadDir);
        } else {
            this.uploadDir = null;
        }
        long timeToLive = this.cfg.getRefreshInterval() * 10L;
        this.executionGraphCache = new ExecutionGraphCache(timeout, Time.milliseconds((long)timeToLive));
        long cleanupInterval = timeToLive * 2L;
        this.executionGraphCleanupTask = scheduledExecutor.scheduleWithFixedDelay(() -> ((ExecutionGraphCache)this.executionGraphCache).cleanup(), cleanupInterval, cleanupInterval, TimeUnit.MILLISECONDS);
        this.stackTraceSamples = new StackTraceSampleCoordinator((Executor)scheduledExecutor, 60000L);
        int cleanUpInterval = config.getInteger(WebOptions.BACKPRESSURE_CLEANUP_INTERVAL);
        int refreshInterval = config.getInteger(WebOptions.BACKPRESSURE_REFRESH_INTERVAL);
        int numSamples = config.getInteger(WebOptions.BACKPRESSURE_NUM_SAMPLES);
        int delay = config.getInteger(WebOptions.BACKPRESSURE_DELAY);
        Time delayBetweenSamples = Time.milliseconds((long)delay);
        this.backPressureStatsTrackerImpl = new BackPressureStatsTrackerImpl(this.stackTraceSamples, cleanUpInterval, numSamples, config.getInteger(WebOptions.BACKPRESSURE_REFRESH_INTERVAL), delayBetweenSamples);
        boolean bl = enableSSL = SSLUtils.isRestSSLEnabled((Configuration)config) && config.getBoolean(WebOptions.SSL_ENABLED);
        if (enableSSL) {
            LOG.info("Enabling ssl for the web frontend");
            try {
                sslFactory = SSLUtils.createRestServerSSLEngineFactory((Configuration)config);
            }
            catch (Exception e) {
                throw new IOException("Failed to initialize SSLContext for the web frontend", e);
            }
        } else {
            sslFactory = null;
        }
        this.metricFetcher = new MetricFetcher(this.retriever, queryServiceRetriever, (Executor)scheduledExecutor, timeout);
        Router router = new Router();
        ShutdownHookUtil.addShutdownHook(this::cleanup, (String)this.getClass().getSimpleName(), (Logger)LOG);
        this.netty = new WebFrontendBootstrap(router, LOG, this.uploadDir, sslFactory, configuredAddress, configuredPort, config);
        this.localRestAddress.complete(this.netty.getRestAddress());
    }

    public static JsonArchivist[] getJsonArchivists() {
        JsonArchivist[] archivists = new JsonArchivist[]{};
        return archivists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Object object = this.startupShutdownLock;
        synchronized (object) {
            this.leaderRetrievalService.start(this.retriever);
            long delay = this.backPressureStatsTrackerImpl.getCleanUpInterval();
            this.netty.getBootstrap().childGroup().scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        WebRuntimeMonitor.this.backPressureStatsTrackerImpl.cleanUpOperatorStatsCache();
                    }
                    catch (Throwable t) {
                        LOG.error("Error during back pressure stats cache cleanup.", t);
                    }
                }
            }, delay, delay, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Object object = this.startupShutdownLock;
        synchronized (object) {
            this.executionGraphCleanupTask.cancel(false);
            this.executionGraphCache.close();
            this.leaderRetrievalService.stop();
            this.netty.shutdown();
            this.stackTraceSamples.shutDown();
            this.backPressureStatsTrackerImpl.shutDown();
            this.cleanup();
        }
    }

    public int getServerPort() {
        return this.netty.getServerPort();
    }

    public String getRestAddress() {
        return this.netty.getRestAddress();
    }

    private void cleanup() {
        if (!this.cleanedUp.compareAndSet(false, true)) {
            return;
        }
        try {
            LOG.info("Removing web dashboard root cache directory {}", (Object)this.webRootDir);
            FileUtils.deleteDirectory((File)this.webRootDir);
        }
        catch (Throwable t) {
            LOG.warn("Error while deleting web root directory {}", (Object)this.webRootDir, (Object)t);
        }
        if (this.uploadDir != null) {
            try {
                LOG.info("Removing web dashboard jar upload directory {}", (Object)this.uploadDir);
                FileUtils.deleteDirectory((File)this.uploadDir);
            }
            catch (Throwable t) {
                LOG.warn("Error while deleting web storage dir {}", (Object)this.uploadDir, (Object)t);
            }
        }
    }

    File getBaseDir(Configuration configuration) {
        return new File(this.getBaseDirStr(configuration));
    }

    private String getBaseDirStr(Configuration configuration) {
        return configuration.getString(WebOptions.TMP_DIR);
    }

    private File getUploadDir(Configuration configuration) {
        File baseDir = new File(configuration.getString(WebOptions.UPLOAD_DIR, this.getBaseDirStr(configuration)));
        boolean uploadDirSpecified = configuration.contains(WebOptions.UPLOAD_DIR);
        return uploadDirSpecified ? baseDir : new File(baseDir, "flink-web-" + UUID.randomUUID());
    }

    public static void logExternalUploadDirDeletion(File uploadDir) {
        LOG.warn("Jar storage directory {} has been deleted externally. Previously uploaded jars are no longer available.", (Object)uploadDir.getAbsolutePath());
    }

    public static synchronized void checkAndCreateUploadDir(File uploadDir) throws IOException {
        if (uploadDir.exists() && uploadDir.canWrite()) {
            LOG.info("Using directory {} for web frontend JAR file uploads.", (Object)uploadDir);
        } else if (uploadDir.mkdirs() && uploadDir.canWrite()) {
            LOG.info("Created directory {} for web frontend JAR file uploads.", (Object)uploadDir);
        } else {
            LOG.warn("Jar upload directory {} cannot be created or is not writable.", (Object)uploadDir.getAbsolutePath());
            throw new IOException(String.format("Jar upload directory %s cannot be created or is not writable.", uploadDir.getAbsolutePath()));
        }
    }
}

