/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.WebOptions;

public class WebMonitorConfig {
    private final Configuration config;

    public WebMonitorConfig(Configuration config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this.config = config;
    }

    public String getWebFrontendAddress() {
        return this.config.getValue(WebOptions.ADDRESS);
    }

    public int getWebFrontendPort() {
        return this.config.getInteger(WebOptions.PORT);
    }

    public long getRefreshInterval() {
        return this.config.getLong(WebOptions.REFRESH_INTERVAL);
    }

    public boolean isProgramSubmitEnabled() {
        return this.config.getBoolean(WebOptions.SUBMIT_ENABLE);
    }

    public String getAllowOrigin() {
        return this.config.getString(WebOptions.ACCESS_CONTROL_ALLOW_ORIGIN);
    }
}

