/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.messages;

import java.nio.ByteBuffer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.queryablestate.KvStateID;
import org.apache.flink.queryablestate.network.messages.MessageBody;
import org.apache.flink.queryablestate.network.messages.MessageDeserializer;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.util.Preconditions;

@Internal
public class KvStateInternalRequest
extends MessageBody {
    private final KvStateID kvStateId;
    private final byte[] serializedKeyAndNamespace;

    public KvStateInternalRequest(KvStateID stateId, byte[] serializedKeyAndNamespace) {
        this.kvStateId = (KvStateID)Preconditions.checkNotNull((Object)stateId);
        this.serializedKeyAndNamespace = (byte[])Preconditions.checkNotNull((Object)serializedKeyAndNamespace);
    }

    public KvStateID getKvStateId() {
        return this.kvStateId;
    }

    public byte[] getSerializedKeyAndNamespace() {
        return this.serializedKeyAndNamespace;
    }

    public byte[] serialize() {
        int size = 20 + this.serializedKeyAndNamespace.length;
        return ByteBuffer.allocate(size).putLong(this.kvStateId.getLowerPart()).putLong(this.kvStateId.getUpperPart()).putInt(this.serializedKeyAndNamespace.length).put(this.serializedKeyAndNamespace).array();
    }

    public static class KvStateInternalRequestDeserializer
    implements MessageDeserializer<KvStateInternalRequest> {
        public KvStateInternalRequest deserializeMessage(ByteBuf buf) {
            KvStateID kvStateId = new KvStateID(buf.readLong(), buf.readLong());
            int length = buf.readInt();
            Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"Negative length for key and namespace. This indicates a serialization error.");
            byte[] serializedKeyAndNamespace = new byte[length];
            if (length > 0) {
                buf.readBytes(serializedKeyAndNamespace);
            }
            return new KvStateInternalRequest(kvStateId, serializedKeyAndNamespace);
        }
    }
}

