/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.network;

import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.buffer.CompositeByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.PooledByteBufAllocator;
import org.apache.flink.util.Preconditions;

public class NettyBufferPool
implements ByteBufAllocator {
    private final PooledByteBufAllocator alloc;

    public NettyBufferPool(int numberOfArenas) {
        Preconditions.checkArgument((numberOfArenas >= 1 ? 1 : 0) != 0, (Object)"Number of arenas");
        boolean preferDirect = true;
        int pageSize = 8192;
        int maxOrder = 11;
        int numDirectArenas = numberOfArenas;
        int numHeapArenas = 0;
        this.alloc = new PooledByteBufAllocator(preferDirect, numHeapArenas, numDirectArenas, pageSize, maxOrder);
    }

    public ByteBuf buffer() {
        return this.alloc.buffer();
    }

    public ByteBuf buffer(int initialCapacity) {
        return this.alloc.buffer(initialCapacity);
    }

    public ByteBuf buffer(int initialCapacity, int maxCapacity) {
        return this.alloc.buffer(initialCapacity, maxCapacity);
    }

    public ByteBuf ioBuffer() {
        return this.alloc.ioBuffer();
    }

    public ByteBuf ioBuffer(int initialCapacity) {
        return this.alloc.ioBuffer(initialCapacity);
    }

    public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
        return this.alloc.ioBuffer(initialCapacity, maxCapacity);
    }

    public ByteBuf heapBuffer() {
        throw new UnsupportedOperationException("Heap buffer");
    }

    public ByteBuf heapBuffer(int initialCapacity) {
        throw new UnsupportedOperationException("Heap buffer");
    }

    public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
        throw new UnsupportedOperationException("Heap buffer");
    }

    public ByteBuf directBuffer() {
        return this.alloc.directBuffer();
    }

    public ByteBuf directBuffer(int initialCapacity) {
        return this.alloc.directBuffer(initialCapacity);
    }

    public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
        return this.alloc.directBuffer(initialCapacity, maxCapacity);
    }

    public CompositeByteBuf compositeBuffer() {
        return this.alloc.compositeBuffer();
    }

    public CompositeByteBuf compositeBuffer(int maxNumComponents) {
        return this.alloc.compositeBuffer(maxNumComponents);
    }

    public CompositeByteBuf compositeHeapBuffer() {
        throw new UnsupportedOperationException("Heap buffer");
    }

    public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
        throw new UnsupportedOperationException("Heap buffer");
    }

    public CompositeByteBuf compositeDirectBuffer() {
        return this.alloc.compositeDirectBuffer();
    }

    public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
        return this.alloc.compositeDirectBuffer(maxNumComponents);
    }

    public boolean isDirectBufferPooled() {
        return this.alloc.isDirectBufferPooled();
    }
}

