/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.util;

import com.google.protobuf.Descriptors;
import java.util.EnumMap;
import java.util.EnumSet;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;

public class PbSchemaValidationUtils {
    private static final EnumMap<Descriptors.FieldDescriptor.JavaType, EnumSet<LogicalTypeRoot>> TYPE_MATCH_MAP = new EnumMap(Descriptors.FieldDescriptor.JavaType.class);

    public static void validate(Descriptors.Descriptor descriptor, RowType rowType) {
        PbSchemaValidationUtils.validateTypeMatch(descriptor, rowType);
    }

    private static void validateTypeMatch(Descriptors.Descriptor descriptor, RowType rowType) {
        rowType.getFields().forEach(rowField -> {
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(rowField.getName());
            if (null == fieldDescriptor) {
                throw new ValidationException("Column " + rowField.getName() + " does not exists in definition of proto class.");
            }
            PbSchemaValidationUtils.validateTypeMatch(fieldDescriptor, rowField.getType());
        });
    }

    private static void validateTypeMatch(Descriptors.FieldDescriptor fd, LogicalType logicalType) {
        if (!fd.isRepeated()) {
            if (fd.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                PbSchemaValidationUtils.validateSimpleType(fd, logicalType.getTypeRoot());
            } else {
                if (!(logicalType instanceof RowType)) {
                    throw new ValidationException("Unexpected LogicalType: " + logicalType + ". It should be RowType");
                }
                PbSchemaValidationUtils.validateTypeMatch(fd.getMessageType(), (RowType)logicalType);
            }
        } else if (fd.isMapField()) {
            if (!(logicalType instanceof MapType)) {
                throw new ValidationException("Unexpected LogicalType: " + logicalType + ". It should be MapType");
            }
            MapType mapType = (MapType)logicalType;
            PbSchemaValidationUtils.validateSimpleType(fd.getMessageType().findFieldByName("key"), mapType.getKeyType().getTypeRoot());
            PbSchemaValidationUtils.validateTypeMatch(fd.getMessageType().findFieldByName("value"), mapType.getValueType());
        } else {
            if (!(logicalType instanceof ArrayType)) {
                throw new ValidationException("Unexpected LogicalType: " + logicalType + ". It should be ArrayType");
            }
            ArrayType arrayType = (ArrayType)logicalType;
            if (fd.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                LogicalType elementType = arrayType.getElementType();
                if (!(elementType instanceof RowType)) {
                    throw new ValidationException("Unexpected logicalType: " + elementType + ". It should be RowType");
                }
                PbSchemaValidationUtils.validateTypeMatch(fd.getMessageType(), (RowType)elementType);
            } else {
                PbSchemaValidationUtils.validateSimpleType(fd, arrayType.getElementType().getTypeRoot());
            }
        }
    }

    private static void validateSimpleType(Descriptors.FieldDescriptor fd, LogicalTypeRoot logicalTypeRoot) {
        if (!TYPE_MATCH_MAP.containsKey(fd.getJavaType())) {
            throw new ValidationException("Unsupported protobuf java type: " + fd.getJavaType());
        }
        if (TYPE_MATCH_MAP.get(fd.getJavaType()).stream().noneMatch(x -> x == logicalTypeRoot)) {
            throw new ValidationException("Protobuf field type does not match column type, " + fd.getJavaType() + "(protobuf) is not compatible of " + logicalTypeRoot);
        }
    }

    static {
        TYPE_MATCH_MAP.put(Descriptors.FieldDescriptor.JavaType.BOOLEAN, EnumSet.of(LogicalTypeRoot.BOOLEAN));
        TYPE_MATCH_MAP.put(Descriptors.FieldDescriptor.JavaType.BYTE_STRING, EnumSet.of(LogicalTypeRoot.BINARY, LogicalTypeRoot.VARBINARY));
        TYPE_MATCH_MAP.put(Descriptors.FieldDescriptor.JavaType.DOUBLE, EnumSet.of(LogicalTypeRoot.DOUBLE));
        TYPE_MATCH_MAP.put(Descriptors.FieldDescriptor.JavaType.FLOAT, EnumSet.of(LogicalTypeRoot.FLOAT));
        TYPE_MATCH_MAP.put(Descriptors.FieldDescriptor.JavaType.ENUM, EnumSet.of(LogicalTypeRoot.VARCHAR, new LogicalTypeRoot[]{LogicalTypeRoot.CHAR, LogicalTypeRoot.TINYINT, LogicalTypeRoot.SMALLINT, LogicalTypeRoot.INTEGER, LogicalTypeRoot.BIGINT}));
        TYPE_MATCH_MAP.put(Descriptors.FieldDescriptor.JavaType.STRING, EnumSet.of(LogicalTypeRoot.VARCHAR, LogicalTypeRoot.CHAR));
        TYPE_MATCH_MAP.put(Descriptors.FieldDescriptor.JavaType.INT, EnumSet.of(LogicalTypeRoot.INTEGER));
        TYPE_MATCH_MAP.put(Descriptors.FieldDescriptor.JavaType.LONG, EnumSet.of(LogicalTypeRoot.BIGINT));
    }
}

