/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.serialize;

import com.google.protobuf.Descriptors;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbFormatContext;
import org.apache.flink.formats.protobuf.serialize.PbCodegenSerializeFactory;
import org.apache.flink.formats.protobuf.serialize.PbCodegenSerializer;
import org.apache.flink.formats.protobuf.util.PbCodegenAppender;
import org.apache.flink.formats.protobuf.util.PbCodegenUtils;
import org.apache.flink.formats.protobuf.util.PbCodegenVarId;
import org.apache.flink.formats.protobuf.util.PbFormatUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;

public class PbCodegenRowSerializer
implements PbCodegenSerializer {
    private final Descriptors.Descriptor descriptor;
    private final RowType rowType;
    private final PbFormatContext formatContext;

    public PbCodegenRowSerializer(Descriptors.Descriptor descriptor, RowType rowType, PbFormatContext formatContext) {
        this.rowType = rowType;
        this.descriptor = descriptor;
        this.formatContext = formatContext;
    }

    @Override
    public String codegen(String resultVar, String flinkObjectCode, int indent) throws PbCodegenException {
        PbCodegenVarId varUid = PbCodegenVarId.getInstance();
        int uid = varUid.getAndIncrement();
        PbCodegenAppender appender = new PbCodegenAppender(indent);
        String flinkRowDataVar = "rowData" + uid;
        String pbMessageTypeStr = PbFormatUtils.getFullJavaName(this.descriptor);
        String messageBuilderVar = "messageBuilder" + uid;
        appender.appendLine("RowData " + flinkRowDataVar + " = " + flinkObjectCode);
        appender.appendLine(pbMessageTypeStr + ".Builder " + messageBuilderVar + " = " + pbMessageTypeStr + ".newBuilder()");
        int index = 0;
        PbCodegenAppender splitAppender = new PbCodegenAppender(indent);
        for (String fieldName : this.rowType.getFieldNames()) {
            Descriptors.FieldDescriptor elementFd = this.descriptor.findFieldByName(fieldName);
            LogicalType subType = this.rowType.getTypeAt(this.rowType.getFieldIndex(fieldName));
            int subUid = varUid.getAndIncrement();
            String elementPbVar = "elementPbVar" + subUid;
            String elementPbTypeStr = elementFd.isMapField() ? PbCodegenUtils.getTypeStrFromProto(elementFd, false) : PbCodegenUtils.getTypeStrFromProto(elementFd, PbFormatUtils.isArrayType(subType));
            String strongCamelFieldName = PbFormatUtils.getStrongCamelCaseJsonName(fieldName);
            splitAppender.begin("if(!" + flinkRowDataVar + ".isNullAt(" + index + ")){");
            splitAppender.appendLine(elementPbTypeStr + " " + elementPbVar);
            String flinkRowElementCode = PbCodegenUtils.flinkContainerElementCode(flinkRowDataVar, index + "", subType);
            PbCodegenSerializer codegen = PbCodegenSerializeFactory.getPbCodegenSer(elementFd, subType, this.formatContext);
            String code = codegen.codegen(elementPbVar, flinkRowElementCode, splitAppender.currentIndent());
            splitAppender.appendSegment(code);
            if (subType.getTypeRoot() == LogicalTypeRoot.ARRAY) {
                splitAppender.appendLine(messageBuilderVar + ".addAll" + strongCamelFieldName + "(" + elementPbVar + ")");
            } else if (subType.getTypeRoot() == LogicalTypeRoot.MAP) {
                splitAppender.appendLine(messageBuilderVar + ".putAll" + strongCamelFieldName + "(" + elementPbVar + ")");
            } else {
                splitAppender.appendLine(messageBuilderVar + ".set" + strongCamelFieldName + "(" + elementPbVar + ")");
            }
            splitAppender.end("}");
            if (PbCodegenUtils.needToSplit(splitAppender.code().length())) {
                String splitMethod = this.formatContext.splitSerializerRowTypeMethod(flinkRowDataVar, pbMessageTypeStr + ".Builder", messageBuilderVar, splitAppender.code());
                appender.appendSegment(splitMethod);
                splitAppender = new PbCodegenAppender();
            }
            ++index;
        }
        if (!splitAppender.code().isEmpty()) {
            String splitMethod = this.formatContext.splitSerializerRowTypeMethod(flinkRowDataVar, pbMessageTypeStr + ".Builder", messageBuilderVar, splitAppender.code());
            appender.appendSegment(splitMethod);
        }
        appender.appendLine(resultVar + " = " + messageBuilderVar + ".build()");
        return appender.code();
    }
}

