/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.shaded.curator5.com.google.common.collect.ImmutableMap;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.util.function.TriFunction;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcFilters {
    private static final Logger LOG = LoggerFactory.getLogger(OrcFilters.class);
    private static final ImmutableMap<FunctionDefinition, Function<CallExpression, Predicate>> FILTERS = new ImmutableMap.Builder().put((Object)BuiltInFunctionDefinitions.IS_NULL, OrcFilters::convertIsNull).put((Object)BuiltInFunctionDefinitions.IS_NOT_NULL, OrcFilters::convertIsNotNull).put((Object)BuiltInFunctionDefinitions.NOT, OrcFilters::convertNot).put((Object)BuiltInFunctionDefinitions.OR, OrcFilters::convertOr).put((Object)BuiltInFunctionDefinitions.AND, OrcFilters::convertAnd).put((Object)BuiltInFunctionDefinitions.EQUALS, call -> OrcFilters.convertBinary(call, (TriFunction<String, PredicateLeaf.Type, Serializable, Predicate>)((TriFunction)OrcFilters::convertEquals), (TriFunction<String, PredicateLeaf.Type, Serializable, Predicate>)((TriFunction)OrcFilters::convertEquals))).put((Object)BuiltInFunctionDefinitions.NOT_EQUALS, call -> OrcFilters.convertBinary(call, (TriFunction<String, PredicateLeaf.Type, Serializable, Predicate>)((TriFunction)OrcFilters::convertNotEquals), (TriFunction<String, PredicateLeaf.Type, Serializable, Predicate>)((TriFunction)OrcFilters::convertNotEquals))).put((Object)BuiltInFunctionDefinitions.GREATER_THAN, call -> OrcFilters.convertBinary(call, (TriFunction<String, PredicateLeaf.Type, Serializable, Predicate>)((TriFunction)OrcFilters::convertGreaterThan), (TriFunction<String, PredicateLeaf.Type, Serializable, Predicate>)((TriFunction)OrcFilters::convertLessThan))).put((Object)BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL, call -> OrcFilters.convertBinary(call, (TriFunction<String, PredicateLeaf.Type, Serializable, Predicate>)((TriFunction)OrcFilters::convertGreaterThanEquals), (TriFunction<String, PredicateLeaf.Type, Serializable, Predicate>)((TriFunction)OrcFilters::convertLessThanEquals))).put((Object)BuiltInFunctionDefinitions.LESS_THAN, call -> OrcFilters.convertBinary(call, (TriFunction<String, PredicateLeaf.Type, Serializable, Predicate>)((TriFunction)OrcFilters::convertLessThan), (TriFunction<String, PredicateLeaf.Type, Serializable, Predicate>)((TriFunction)OrcFilters::convertGreaterThan))).put((Object)BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL, call -> OrcFilters.convertBinary(call, (TriFunction<String, PredicateLeaf.Type, Serializable, Predicate>)((TriFunction)OrcFilters::convertLessThanEquals), (TriFunction<String, PredicateLeaf.Type, Serializable, Predicate>)((TriFunction)OrcFilters::convertGreaterThanEquals))).build();

    private static boolean isRef(Expression expression) {
        return expression instanceof FieldReferenceExpression;
    }

    private static boolean isLit(Expression expression) {
        return expression instanceof ValueLiteralExpression;
    }

    private static boolean isUnaryValid(CallExpression callExpression) {
        return callExpression.getChildren().size() == 1 && OrcFilters.isRef((Expression)callExpression.getChildren().get(0));
    }

    private static boolean isBinaryValid(CallExpression callExpression) {
        return callExpression.getChildren().size() == 2 && (OrcFilters.isRef((Expression)callExpression.getChildren().get(0)) && OrcFilters.isLit((Expression)callExpression.getChildren().get(1)) || OrcFilters.isLit((Expression)callExpression.getChildren().get(0)) && OrcFilters.isRef((Expression)callExpression.getChildren().get(1)));
    }

    private static Predicate convertIsNull(CallExpression callExp) {
        if (!OrcFilters.isUnaryValid(callExp)) {
            LOG.debug("Unsupported predicate [{}] cannot be pushed into OrcFileSystemFormatFactory.", (Object)callExp);
            return null;
        }
        PredicateLeaf.Type colType = OrcFilters.toOrcType(((FieldReferenceExpression)callExp.getChildren().get(0)).getOutputDataType());
        if (colType == null) {
            LOG.debug("Unsupported predicate [{}] cannot be pushed into OrcFileSystemFormatFactory.", (Object)callExp);
            return null;
        }
        String colName = OrcFilters.getColumnName(callExp);
        return new IsNull(colName, colType);
    }

    private static Predicate convertIsNotNull(CallExpression callExp) {
        return new Not(OrcFilters.convertIsNull(callExp));
    }

    private static Predicate convertNot(CallExpression callExp) {
        if (callExp.getChildren().size() != 1) {
            LOG.debug("Unsupported predicate [{}] cannot be pushed into OrcFileSystemFormatFactory.", (Object)callExp);
            return null;
        }
        Predicate c = OrcFilters.toOrcPredicate((Expression)callExp.getChildren().get(0));
        return c == null ? null : new Not(c);
    }

    private static Predicate convertOr(CallExpression callExp) {
        if (callExp.getChildren().size() < 2) {
            return null;
        }
        Expression left = (Expression)callExp.getChildren().get(0);
        Expression right = (Expression)callExp.getChildren().get(1);
        Predicate c1 = OrcFilters.toOrcPredicate(left);
        Predicate c2 = OrcFilters.toOrcPredicate(right);
        if (c1 == null || c2 == null) {
            return null;
        }
        return new Or(c1, c2);
    }

    private static Predicate convertAnd(CallExpression callExp) {
        if (callExp.getChildren().size() < 2) {
            return null;
        }
        Expression left = (Expression)callExp.getChildren().get(0);
        Expression right = (Expression)callExp.getChildren().get(1);
        Predicate c1 = OrcFilters.toOrcPredicate(left);
        Predicate c2 = OrcFilters.toOrcPredicate(right);
        if (c1 == null || c2 == null) {
            return null;
        }
        return new And(c1, c2);
    }

    public static Predicate convertBinary(CallExpression callExp, TriFunction<String, PredicateLeaf.Type, Serializable, Predicate> func, TriFunction<String, PredicateLeaf.Type, Serializable, Predicate> reverseFunc) {
        if (!OrcFilters.isBinaryValid(callExp)) {
            LOG.debug("Unsupported predicate [{}] cannot be pushed into OrcFileSystemFormatFactory.", (Object)callExp);
            return null;
        }
        PredicateLeaf.Type litType = OrcFilters.getLiteralType(callExp);
        if (litType == null) {
            LOG.debug("Unsupported predicate [{}] cannot be pushed into OrcFileSystemFormatFactory.", (Object)callExp);
            return null;
        }
        String colName = OrcFilters.getColumnName(callExp);
        Object literalObj = OrcFilters.getLiteral(callExp).get();
        Object orcObj = OrcFilters.toOrcObject(litType, literalObj);
        if (!(orcObj instanceof Serializable)) {
            LOG.warn("Encountered a non-serializable literal of type {}. Cannot push predicate [{}] into OrcFileSystemFormatFactory. This is a bug and should be reported.", (Object)literalObj.getClass().getCanonicalName(), (Object)callExp);
            return null;
        }
        Serializable literal = (Serializable)orcObj;
        return OrcFilters.literalOnRight(callExp) ? (Predicate)func.apply((Object)colName, (Object)litType, (Object)literal) : (Predicate)reverseFunc.apply((Object)colName, (Object)litType, (Object)literal);
    }

    private static Predicate convertEquals(String colName, PredicateLeaf.Type litType, Serializable literal) {
        return new Equals(colName, litType, literal);
    }

    private static Predicate convertNotEquals(String colName, PredicateLeaf.Type litType, Serializable literal) {
        return new Not(OrcFilters.convertEquals(colName, litType, literal));
    }

    private static Predicate convertGreaterThan(String colName, PredicateLeaf.Type litType, Serializable literal) {
        return new Not(new LessThanEquals(colName, litType, literal));
    }

    private static Predicate convertGreaterThanEquals(String colName, PredicateLeaf.Type litType, Serializable literal) {
        return new Not(new LessThan(colName, litType, literal));
    }

    private static Predicate convertLessThan(String colName, PredicateLeaf.Type litType, Serializable literal) {
        return new LessThan(colName, litType, literal);
    }

    private static Predicate convertLessThanEquals(String colName, PredicateLeaf.Type litType, Serializable literal) {
        return new LessThanEquals(colName, litType, literal);
    }

    public static Predicate toOrcPredicate(Expression expression) {
        if (expression instanceof CallExpression) {
            CallExpression callExp = (CallExpression)expression;
            if (FILTERS.get((Object)callExp.getFunctionDefinition()) == null) {
                LOG.debug("Unsupported predicate [{}] cannot be pushed into OrcFileSystemFormatFactory.", (Object)expression);
                return null;
            }
            return (Predicate)((Function)FILTERS.get((Object)callExp.getFunctionDefinition())).apply(callExp);
        }
        LOG.debug("Unsupported predicate [{}] cannot be pushed into OrcFileSystemFormatFactory.", (Object)expression);
        return null;
    }

    private static String getColumnName(CallExpression comp) {
        if (OrcFilters.literalOnRight(comp)) {
            return ((FieldReferenceExpression)comp.getChildren().get(0)).getName();
        }
        return ((FieldReferenceExpression)comp.getChildren().get(1)).getName();
    }

    private static boolean literalOnRight(CallExpression comp) {
        if (comp.getChildren().size() == 1 && comp.getChildren().get(0) instanceof FieldReferenceExpression) {
            return true;
        }
        if (OrcFilters.isLit((Expression)comp.getChildren().get(0)) && OrcFilters.isRef((Expression)comp.getChildren().get(1))) {
            return false;
        }
        if (OrcFilters.isRef((Expression)comp.getChildren().get(0)) && OrcFilters.isLit((Expression)comp.getChildren().get(1))) {
            return true;
        }
        throw new RuntimeException("Invalid binary comparison.");
    }

    private static PredicateLeaf.Type getLiteralType(CallExpression comp) {
        if (OrcFilters.literalOnRight(comp)) {
            return OrcFilters.toOrcType(((ValueLiteralExpression)comp.getChildren().get(1)).getOutputDataType());
        }
        return OrcFilters.toOrcType(((ValueLiteralExpression)comp.getChildren().get(0)).getOutputDataType());
    }

    private static Object toOrcObject(PredicateLeaf.Type litType, Object literalObj) {
        switch (litType) {
            case DATE: {
                if (literalObj instanceof LocalDate) {
                    LocalDate localDate = (LocalDate)literalObj;
                    return Date.valueOf(localDate);
                }
                return literalObj;
            }
            case TIMESTAMP: {
                if (literalObj instanceof LocalDateTime) {
                    LocalDateTime localDateTime = (LocalDateTime)literalObj;
                    return Timestamp.valueOf(localDateTime);
                }
                return literalObj;
            }
        }
        return literalObj;
    }

    private static Optional<?> getLiteral(CallExpression comp) {
        if (OrcFilters.literalOnRight(comp)) {
            ValueLiteralExpression valueLiteralExpression = (ValueLiteralExpression)comp.getChildren().get(1);
            return valueLiteralExpression.getValueAs(valueLiteralExpression.getOutputDataType().getConversionClass());
        }
        ValueLiteralExpression valueLiteralExpression = (ValueLiteralExpression)comp.getChildren().get(0);
        return valueLiteralExpression.getValueAs(valueLiteralExpression.getOutputDataType().getConversionClass());
    }

    private static PredicateLeaf.Type toOrcType(DataType type) {
        LogicalTypeRoot ltype = type.getLogicalType().getTypeRoot();
        switch (ltype) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return PredicateLeaf.Type.LONG;
            }
            case FLOAT: 
            case DOUBLE: {
                return PredicateLeaf.Type.FLOAT;
            }
            case BOOLEAN: {
                return PredicateLeaf.Type.BOOLEAN;
            }
            case CHAR: 
            case VARCHAR: {
                return PredicateLeaf.Type.STRING;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return PredicateLeaf.Type.TIMESTAMP;
            }
            case DATE: {
                return PredicateLeaf.Type.DATE;
            }
            case DECIMAL: {
                return PredicateLeaf.Type.DECIMAL;
            }
        }
        return null;
    }

    public static class And
    extends Predicate {
        private final Predicate[] preds;

        public And(Predicate ... predicates) {
            this.preds = predicates;
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            SearchArgument.Builder withAnd = builder.startAnd();
            for (Predicate pred : this.preds) {
                withAnd = pred.add(withAnd);
            }
            return withAnd.end();
        }

        public String toString() {
            return "AND(" + Arrays.toString(this.preds) + ")";
        }
    }

    public static class Or
    extends Predicate {
        private final Predicate[] preds;

        public Or(Predicate ... predicates) {
            this.preds = predicates;
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            SearchArgument.Builder withOr = builder.startOr();
            for (Predicate p : this.preds) {
                withOr = p.add(withOr);
            }
            return withOr.end();
        }

        protected Iterable<Predicate> children() {
            return Arrays.asList(this.preds);
        }

        public String toString() {
            return "OR(" + Arrays.toString(this.preds) + ")";
        }
    }

    public static class Not
    extends Predicate {
        private final Predicate pred;

        public Not(Predicate predicate) {
            this.pred = predicate;
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            return this.pred.add(builder.startNot()).end();
        }

        protected Predicate child() {
            return this.pred;
        }

        public String toString() {
            return "NOT(" + this.pred.toString() + ")";
        }
    }

    public static class In
    extends ColumnPredicate {
        private Serializable[] literals;

        public In(String columnName, PredicateLeaf.Type literalType, Serializable ... literals) {
            super(columnName, literalType);
            this.literals = literals;
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            Object[] castedLiterals = new Object[this.literals.length];
            for (int i = 0; i < this.literals.length; ++i) {
                castedLiterals[i] = this.castLiteral(this.literals[i]);
            }
            return builder.in(this.columnName, this.literalType, castedLiterals);
        }

        public String toString() {
            return this.columnName + " IN " + Arrays.toString(this.literals);
        }
    }

    public static class Between
    extends ColumnPredicate {
        private Serializable lowerBound;
        private Serializable upperBound;

        public Between(String columnName, PredicateLeaf.Type literalType, Serializable lowerBound, Serializable upperBound) {
            super(columnName, literalType);
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            return builder.between(this.columnName, this.literalType, this.castLiteral(this.lowerBound), this.castLiteral(this.upperBound));
        }

        public String toString() {
            return this.lowerBound + " <= " + this.columnName + " <= " + this.upperBound;
        }
    }

    public static class IsNull
    extends ColumnPredicate {
        public IsNull(String columnName, PredicateLeaf.Type literalType) {
            super(columnName, literalType);
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            return builder.isNull(this.columnName, this.literalType);
        }

        public String toString() {
            return this.columnName + " IS NULL";
        }
    }

    public static class LessThanEquals
    extends BinaryPredicate {
        public LessThanEquals(String columnName, PredicateLeaf.Type literalType, Serializable literal) {
            super(columnName, literalType, literal);
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            return builder.lessThanEquals(this.columnName, this.literalType, this.castLiteral(this.literal));
        }

        public String toString() {
            return this.columnName + " <= " + this.literal;
        }
    }

    public static class LessThan
    extends BinaryPredicate {
        public LessThan(String columnName, PredicateLeaf.Type literalType, Serializable literal) {
            super(columnName, literalType, literal);
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            return builder.lessThan(this.columnName, this.literalType, this.castLiteral(this.literal));
        }

        public String toString() {
            return this.columnName + " < " + this.literal;
        }
    }

    public static class NullSafeEquals
    extends BinaryPredicate {
        public NullSafeEquals(String columnName, PredicateLeaf.Type literalType, Serializable literal) {
            super(columnName, literalType, literal);
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            return builder.nullSafeEquals(this.columnName, this.literalType, this.castLiteral(this.literal));
        }

        public String toString() {
            return this.columnName + " = " + this.literal;
        }
    }

    public static class Equals
    extends BinaryPredicate {
        public Equals(String columnName, PredicateLeaf.Type literalType, Serializable literal) {
            super(columnName, literalType, literal);
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            return builder.equals(this.columnName, this.literalType, this.castLiteral(this.literal));
        }

        public String toString() {
            return this.columnName + " = " + this.literal;
        }
    }

    static abstract class BinaryPredicate
    extends ColumnPredicate {
        final Serializable literal;

        BinaryPredicate(String columnName, PredicateLeaf.Type literalType, Serializable literal) {
            super(columnName, literalType);
            this.literal = literal;
        }
    }

    static abstract class ColumnPredicate
    extends Predicate {
        final String columnName;
        final PredicateLeaf.Type literalType;

        ColumnPredicate(String columnName, PredicateLeaf.Type literalType) {
            this.columnName = columnName;
            this.literalType = literalType;
        }

        Object castLiteral(Serializable literal) {
            switch (this.literalType) {
                case LONG: {
                    if (literal instanceof Byte) {
                        return new Long(((Byte)literal).byteValue());
                    }
                    if (literal instanceof Short) {
                        return new Long(((Short)literal).shortValue());
                    }
                    if (literal instanceof Integer) {
                        return new Long(((Integer)literal).intValue());
                    }
                    if (literal instanceof Long) {
                        return literal;
                    }
                    throw new IllegalArgumentException("A predicate on a LONG column requires an integer literal, i.e., Byte, Short, Integer, or Long.");
                }
                case FLOAT: {
                    if (literal instanceof Float) {
                        return new Double(((Float)literal).floatValue());
                    }
                    if (literal instanceof Double) {
                        return literal;
                    }
                    if (literal instanceof BigDecimal) {
                        return ((BigDecimal)literal).doubleValue();
                    }
                    throw new IllegalArgumentException("A predicate on a FLOAT column requires a floating literal, i.e., Float or Double.");
                }
                case STRING: {
                    if (literal instanceof String) {
                        return literal;
                    }
                    throw new IllegalArgumentException("A predicate on a STRING column requires a floating literal, i.e., Float or Double.");
                }
                case BOOLEAN: {
                    if (literal instanceof Boolean) {
                        return literal;
                    }
                    throw new IllegalArgumentException("A predicate on a BOOLEAN column requires a Boolean literal.");
                }
                case DATE: {
                    if (literal instanceof Date) {
                        return literal;
                    }
                    throw new IllegalArgumentException("A predicate on a DATE column requires a java.sql.Date literal.");
                }
                case TIMESTAMP: {
                    if (literal instanceof Timestamp) {
                        return literal;
                    }
                    throw new IllegalArgumentException("A predicate on a TIMESTAMP column requires a java.sql.Timestamp literal.");
                }
                case DECIMAL: {
                    if (literal instanceof BigDecimal) {
                        return new HiveDecimalWritable(HiveDecimal.create((BigDecimal)((BigDecimal)literal)));
                    }
                    throw new IllegalArgumentException("A predicate on a DECIMAL column requires a BigDecimal literal.");
                }
            }
            throw new IllegalArgumentException("Unknown literal type " + this.literalType);
        }
    }

    public static abstract class Predicate
    implements Serializable {
        public abstract SearchArgument.Builder add(SearchArgument.Builder var1);
    }
}

