/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;

public final class SerializableHadoopConfigWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Configuration hadoopConfig;

    public SerializableHadoopConfigWrapper(Configuration hadoopConfig) {
        this.hadoopConfig = (Configuration)Preconditions.checkNotNull((Object)hadoopConfig);
    }

    public Configuration getHadoopConfig() {
        return this.hadoopConfig;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        DataOutputSerializer ser = new DataOutputSerializer(256);
        this.hadoopConfig.write((DataOutput)ser);
        out.writeInt(ser.length());
        out.write(ser.getSharedBuffer(), 0, ser.length());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] data = new byte[in.readInt()];
        in.readFully(data);
        DataInputDeserializer deser = new DataInputDeserializer(data);
        this.hadoopConfig = new Configuration();
        try {
            this.hadoopConfig.readFields((DataInput)deser);
        }
        catch (IOException e) {
            throw new IOException("Could not deserialize Hadoop Configuration, the serialized and de-serialized don't match.", e);
        }
    }
}

