/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.plan;

import java.util.Collections;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.optimizer.dag.DataSourceNode;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.util.Visitable;
import org.apache.flink.util.Visitor;

public class SourcePlanNode
extends PlanNode {
    private TypeSerializerFactory<?> serializer;

    public SourcePlanNode(DataSourceNode template, String nodeName) {
        this(template, nodeName, new GlobalProperties(), new LocalProperties());
    }

    public SourcePlanNode(DataSourceNode template, String nodeName, GlobalProperties gprops, LocalProperties lprops) {
        super(template, nodeName, DriverStrategy.NONE);
        this.globalProps = gprops;
        this.localProps = lprops;
        this.updatePropertiesWithUniqueSets(template.getUniqueFields());
    }

    public DataSourceNode getDataSourceNode() {
        return (DataSourceNode)this.template;
    }

    public TypeSerializerFactory<?> getSerializer() {
        return this.serializer;
    }

    public void setSerializer(TypeSerializerFactory<?> serializer) {
        this.serializer = serializer;
    }

    public void accept(Visitor<PlanNode> visitor) {
        if (visitor.preVisit((Visitable)this)) {
            visitor.postVisit((Visitable)this);
        }
    }

    @Override
    public Iterable<PlanNode> getPredecessors() {
        return Collections.emptyList();
    }

    @Override
    public Iterable<Channel> getInputs() {
        return Collections.emptyList();
    }

    @Override
    public PlanNode.SourceAndDamReport hasDamOnPathDownTo(PlanNode source) {
        if (source == this) {
            return PlanNode.SourceAndDamReport.FOUND_SOURCE;
        }
        return PlanNode.SourceAndDamReport.NOT_FOUND;
    }
}

