/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.typeinfo.NothingTypeInfo;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.dag.DagConnection;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.optimizer.dag.TwoInputNode;
import org.apache.flink.optimizer.operators.OperatorDescriptorDual;
import org.apache.flink.optimizer.operators.UtilSinkJoinOpDescriptor;
import org.apache.flink.optimizer.util.NoOpBinaryUdfOp;

public class SinkJoiner
extends TwoInputNode {
    public SinkJoiner(OptimizerNode input1, OptimizerNode input2) {
        super(new NoOpBinaryUdfOp(new NothingTypeInfo()));
        DagConnection conn1 = new DagConnection(input1, this, null, ExecutionMode.PIPELINED);
        DagConnection conn2 = new DagConnection(input2, this, null, ExecutionMode.PIPELINED);
        this.input1 = conn1;
        this.input2 = conn2;
        this.setParallelism(1);
    }

    @Override
    public String getOperatorName() {
        return "Internal Utility Node";
    }

    @Override
    public List<DagConnection> getOutgoingConnections() {
        return Collections.emptyList();
    }

    @Override
    public void computeUnclosedBranchStack() {
        if (this.openBranches != null) {
            return;
        }
        this.addClosedBranches(this.getFirstPredecessorNode().closedBranchingNodes);
        this.addClosedBranches(this.getSecondPredecessorNode().closedBranchingNodes);
        List<OptimizerNode.UnclosedBranchDescriptor> pred1branches = this.getFirstPredecessorNode().openBranches;
        List<OptimizerNode.UnclosedBranchDescriptor> pred2branches = this.getSecondPredecessorNode().openBranches;
        if (pred1branches == null || pred1branches.isEmpty()) {
            this.openBranches = pred2branches == null || pred2branches.isEmpty() ? Collections.emptyList() : pred2branches;
        } else if (pred2branches == null || pred2branches.isEmpty()) {
            this.openBranches = pred1branches;
        } else {
            ArrayList<OptimizerNode.UnclosedBranchDescriptor> result1 = new ArrayList<OptimizerNode.UnclosedBranchDescriptor>(pred1branches);
            ArrayList<OptimizerNode.UnclosedBranchDescriptor> result2 = new ArrayList<OptimizerNode.UnclosedBranchDescriptor>(pred2branches);
            ArrayList<OptimizerNode.UnclosedBranchDescriptor> result = new ArrayList<OptimizerNode.UnclosedBranchDescriptor>();
            this.mergeLists(result1, result2, result, false);
            this.openBranches = result.isEmpty() ? Collections.emptyList() : result;
        }
    }

    @Override
    protected List<OperatorDescriptorDual> getPossibleProperties() {
        return Collections.singletonList(new UtilSinkJoinOpDescriptor());
    }

    @Override
    public void computeOutputEstimates(DataStatistics statistics) {
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
    }
}

