/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.plan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.costs.Costs;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.NamedChannel;
import org.apache.flink.optimizer.plandump.DumpableConnection;
import org.apache.flink.optimizer.plandump.DumpableNode;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.runtime.operators.util.LocalStrategy;
import org.apache.flink.util.Visitable;

public abstract class PlanNode
implements Visitable<PlanNode>,
DumpableNode<PlanNode> {
    protected final OptimizerNode template;
    protected final List<Channel> outChannels = new ArrayList<Channel>(2);
    private List<NamedChannel> broadcastInputs = new ArrayList<NamedChannel>();
    private final String nodeName;
    private DriverStrategy driverStrategy;
    protected LocalProperties localProps;
    protected GlobalProperties globalProps;
    protected Map<OptimizerNode, PlanNode> branchPlan;
    protected Costs nodeCosts;
    protected Costs cumulativeCosts;
    private double relativeMemoryPerSubTask;
    private int parallelism;
    private boolean pFlag;

    public PlanNode(OptimizerNode template, String nodeName, DriverStrategy strategy) {
        this.template = template;
        this.nodeName = nodeName;
        this.driverStrategy = strategy;
        this.parallelism = template.getParallelism();
        if (template.isBranching()) {
            this.branchPlan = new HashMap<OptimizerNode, PlanNode>(6);
            this.branchPlan.put(template, this);
        }
    }

    protected void mergeBranchPlanMaps(PlanNode pred1, PlanNode pred2) {
        this.mergeBranchPlanMaps(pred1.branchPlan, pred2.branchPlan);
    }

    protected void mergeBranchPlanMaps(Map<OptimizerNode, PlanNode> branchPlan1, Map<OptimizerNode, PlanNode> branchPlan2) {
        if (this.template.hasUnclosedBranches()) {
            if (this.branchPlan == null) {
                this.branchPlan = new HashMap<OptimizerNode, PlanNode>(8);
            }
            for (OptimizerNode.UnclosedBranchDescriptor uc : this.template.getOpenBranches()) {
                OptimizerNode brancher = uc.getBranchingNode();
                PlanNode selectedCandidate = null;
                if (branchPlan1 != null) {
                    selectedCandidate = branchPlan1.get(brancher);
                }
                if (selectedCandidate == null && branchPlan2 != null) {
                    selectedCandidate = branchPlan2.get(brancher);
                }
                if (selectedCandidate == null) continue;
                this.branchPlan.put(brancher, selectedCandidate);
            }
        }
    }

    public OptimizerNode getOriginalOptimizerNode() {
        return this.template;
    }

    public Operator<?> getProgramOperator() {
        return this.template.getOperator();
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public int getMemoryConsumerWeight() {
        return this.driverStrategy.isMaterializing() ? 1 : 0;
    }

    public double getRelativeMemoryPerSubTask() {
        return this.relativeMemoryPerSubTask;
    }

    public void setRelativeMemoryPerSubtask(double relativeMemoryPerSubtask) {
        this.relativeMemoryPerSubTask = relativeMemoryPerSubtask;
    }

    public DriverStrategy getDriverStrategy() {
        return this.driverStrategy;
    }

    public void setDriverStrategy(DriverStrategy newDriverStrategy) {
        this.driverStrategy = newDriverStrategy;
    }

    public void initProperties(GlobalProperties globals, LocalProperties locals) {
        if (this.globalProps != null || this.localProps != null) {
            throw new IllegalStateException();
        }
        this.globalProps = globals;
        this.localProps = locals;
    }

    public LocalProperties getLocalProperties() {
        return this.localProps;
    }

    public GlobalProperties getGlobalProperties() {
        return this.globalProps;
    }

    public Costs getNodeCosts() {
        return this.nodeCosts;
    }

    public Costs getCumulativeCosts() {
        return this.cumulativeCosts;
    }

    public Costs getCumulativeCostsShare() {
        int outDegree;
        if (this.cumulativeCosts == null) {
            return null;
        }
        Costs result = this.cumulativeCosts.clone();
        if (this.template.getOutgoingConnections() != null && (outDegree = this.template.getOutgoingConnections().size()) > 0) {
            result.divideBy(outDegree);
        }
        return result;
    }

    public void setCosts(Costs nodeCosts) {
        this.nodeCosts = nodeCosts;
        this.cumulativeCosts = nodeCosts.clone();
        for (PlanNode pred : this.getPredecessors()) {
            Costs parentCosts = pred.getCumulativeCostsShare();
            if (parentCosts != null) {
                this.cumulativeCosts.addCosts(parentCosts);
                continue;
            }
            throw new CompilerException("Trying to set the costs of an operator before the predecessor costs are computed.");
        }
        if (this.broadcastInputs != null) {
            for (NamedChannel nc : this.broadcastInputs) {
                Costs bcInputCost = nc.getSource().getCumulativeCostsShare();
                if (bcInputCost != null) {
                    this.cumulativeCosts.addCosts(bcInputCost);
                    continue;
                }
                throw new CompilerException("Trying to set the costs of an operator before the broadcast input costs are computed.");
            }
        }
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public long getGuaranteedAvailableMemory() {
        return this.template.getMinimalMemoryAcrossAllSubTasks();
    }

    public Map<OptimizerNode, PlanNode> getBranchPlan() {
        return this.branchPlan;
    }

    public abstract Iterable<Channel> getInputs();

    @Override
    public abstract Iterable<PlanNode> getPredecessors();

    public void setBroadcastInputs(List<NamedChannel> broadcastInputs) {
        if (broadcastInputs != null) {
            this.broadcastInputs = broadcastInputs;
            for (NamedChannel nc : broadcastInputs) {
                PlanNode source = nc.getSource();
                this.mergeBranchPlanMaps(this.branchPlan, source.branchPlan);
            }
        }
        if (this.template.hasUnclosedBranches()) {
            if (this.branchPlan == null) {
                throw new CompilerException("Branching and rejoining logic did not find a candidate for the branching point.");
            }
            for (OptimizerNode.UnclosedBranchDescriptor uc : this.template.getOpenBranches()) {
                OptimizerNode brancher = uc.getBranchingNode();
                if (this.branchPlan.get(brancher) != null) continue;
                throw new CompilerException("Branching and rejoining logic did not find a candidate for the branching point.");
            }
        }
    }

    public List<NamedChannel> getBroadcastInputs() {
        return this.broadcastInputs;
    }

    public void addOutgoingChannel(Channel channel) {
        this.outChannels.add(channel);
    }

    public List<Channel> getOutgoingChannels() {
        return this.outChannels;
    }

    public void updatePropertiesWithUniqueSets(Set<FieldSet> uniqueFieldCombinations) {
        if (uniqueFieldCombinations == null || uniqueFieldCombinations.isEmpty()) {
            return;
        }
        for (FieldSet fields : uniqueFieldCombinations) {
            this.globalProps.addUniqueFieldCombination(fields);
            this.localProps = this.localProps.addUniqueFields(fields);
        }
    }

    public PlanNode getCandidateAtBranchPoint(OptimizerNode branchPoint) {
        if (this.branchPlan == null) {
            return null;
        }
        return this.branchPlan.get(branchPoint);
    }

    public void setPruningMarker() {
        this.pFlag = true;
    }

    public boolean isPruneMarkerSet() {
        return this.pFlag;
    }

    public boolean isOnDynamicPath() {
        return this.template.isOnDynamicPath();
    }

    public int getCostWeight() {
        return this.template.getCostWeight();
    }

    public abstract SourceAndDamReport hasDamOnPathDownTo(PlanNode var1);

    public FeedbackPropertiesMeetRequirementsReport checkPartialSolutionPropertiesMet(PlanNode partialSolution, GlobalProperties feedbackGlobal, LocalProperties feedbackLocal) {
        if (this == partialSolution) {
            return FeedbackPropertiesMeetRequirementsReport.PENDING;
        }
        boolean found = false;
        boolean allMet = true;
        boolean allLocallyMet = true;
        for (Channel input : this.getInputs()) {
            FeedbackPropertiesMeetRequirementsReport inputState = input.getSource().checkPartialSolutionPropertiesMet(partialSolution, feedbackGlobal, feedbackLocal);
            if (inputState == FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION) continue;
            if (inputState == FeedbackPropertiesMeetRequirementsReport.MET) {
                found = true;
                continue;
            }
            if (inputState == FeedbackPropertiesMeetRequirementsReport.NOT_MET) {
                return FeedbackPropertiesMeetRequirementsReport.NOT_MET;
            }
            found = true;
            if (input.getShipStrategy() != ShipStrategyType.FORWARD && input.getShipStrategy() != ShipStrategyType.NONE) continue;
            if (input.getRequiredGlobalProps() != null && !input.getRequiredGlobalProps().isMetBy(feedbackGlobal)) {
                return FeedbackPropertiesMeetRequirementsReport.NOT_MET;
            }
            allMet = false;
            if (inputState == FeedbackPropertiesMeetRequirementsReport.PENDING_LOCAL_MET || input.getLocalStrategy() != LocalStrategy.NONE) continue;
            if (input.getRequiredLocalProps() != null && !input.getRequiredLocalProps().isMetBy(feedbackLocal)) {
                return FeedbackPropertiesMeetRequirementsReport.NOT_MET;
            }
            allLocallyMet = false;
        }
        if (!found) {
            return FeedbackPropertiesMeetRequirementsReport.NO_PARTIAL_SOLUTION;
        }
        if (allMet) {
            return FeedbackPropertiesMeetRequirementsReport.MET;
        }
        if (allLocallyMet) {
            return FeedbackPropertiesMeetRequirementsReport.PENDING_LOCAL_MET;
        }
        return FeedbackPropertiesMeetRequirementsReport.PENDING;
    }

    public String toString() {
        return this.template.getName() + " \"" + this.getProgramOperator().getName() + "\" : " + this.driverStrategy + " [[ " + this.globalProps + " ]] [[ " + this.localProps + " ]]";
    }

    @Override
    public OptimizerNode getOptimizerNode() {
        return this.template;
    }

    @Override
    public PlanNode getPlanNode() {
        return this;
    }

    @Override
    public Iterable<DumpableConnection<PlanNode>> getDumpableInputs() {
        ArrayList<DumpableConnection<PlanNode>> allInputs = new ArrayList<DumpableConnection<PlanNode>>();
        for (Channel channel : this.getInputs()) {
            allInputs.add(channel);
        }
        for (NamedChannel namedChannel : this.getBroadcastInputs()) {
            allInputs.add(namedChannel);
        }
        return allInputs;
    }

    public static enum FeedbackPropertiesMeetRequirementsReport {
        NO_PARTIAL_SOLUTION,
        PENDING,
        PENDING_LOCAL_MET,
        MET,
        NOT_MET;

    }

    public static enum SourceAndDamReport {
        NOT_FOUND,
        FOUND_SOURCE,
        FOUND_SOURCE_AND_DAM;

    }
}

