/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.util;

import java.util.Arrays;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.optimizer.CompilerException;

public class Utils {
    public static final FieldList createOrderedFromSet(FieldSet set) {
        if (set instanceof FieldList) {
            return (FieldList)set;
        }
        int[] cols = set.toArray();
        Arrays.sort(cols);
        return new FieldList(cols);
    }

    public static final Ordering createOrdering(FieldList fields, boolean[] directions) {
        Ordering o = new Ordering();
        for (int i = 0; i < fields.size(); ++i) {
            o.appendOrdering(fields.get(i), null, directions == null || directions[i] ? Order.ASCENDING : Order.DESCENDING);
        }
        return o;
    }

    public static final Ordering createOrdering(FieldList fields) {
        Ordering o = new Ordering();
        for (int i = 0; i < fields.size(); ++i) {
            o.appendOrdering(fields.get(i), null, Order.ANY);
        }
        return o;
    }

    public static boolean[] getDirections(Ordering o, int numFields) {
        boolean[] dirs = o.getFieldSortDirections();
        if (dirs.length == numFields) {
            return dirs;
        }
        if (dirs.length > numFields) {
            boolean[] subSet = new boolean[numFields];
            System.arraycopy(dirs, 0, subSet, 0, numFields);
            return subSet;
        }
        throw new CompilerException();
    }

    private Utils() {
    }
}

