/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.deadlockdetect;

import java.util.LinkedList;
import java.util.List;
import org.apache.flink.optimizer.deadlockdetect.DeadlockEdge;
import org.apache.flink.optimizer.plan.PlanNode;

public class DeadlockVertex {
    private PlanNode original;
    private List<DeadlockEdge> outEdges;
    private int inDegree;

    public DeadlockVertex(PlanNode original) {
        this.original = original;
        this.outEdges = new LinkedList<DeadlockEdge>();
        this.inDegree = 0;
    }

    public void addEdge(DeadlockVertex destination) {
        for (DeadlockEdge e : this.outEdges) {
            if (!e.getDestination().equals(destination)) continue;
            return;
        }
        DeadlockEdge e = new DeadlockEdge(destination);
        this.outEdges.add(e);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DeadlockVertex)) {
            return false;
        }
        DeadlockVertex v = (DeadlockVertex)o;
        return v.getOriginal().equals(this.getOriginal());
    }

    public int hashCode() {
        return this.original.hashCode();
    }

    public String toString() {
        return this.original.toString();
    }

    public PlanNode getOriginal() {
        return this.original;
    }

    public void setOriginal(PlanNode original) {
        this.original = original;
    }

    public int getInDegree() {
        return this.inDegree;
    }

    public void setInDegree(int inDegree) {
        this.inDegree = inDegree;
    }

    public List<DeadlockEdge> getOutEdges() {
        return this.outEdges;
    }

    public void setOutEdges(List<DeadlockEdge> outEdges) {
        this.outEdges = outEdges;
    }
}

