/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.model.openai;

import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.EncodingResult;
import com.knuddels.jtokkit.api.IntArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.flink.configuration.DescribedEnum;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ContextOverflowAction implements DescribedEnum
{
    TRUNCATED_TAIL("truncated-tail", "Truncates exceeded tokens from the tail of the context."){

        @Override
        public String processTokensWithLimitInternal(Encoding encoding, String input2, int maxContextSize, int actualNumTokens) {
            EncodingResult encodingResult = encoding.encodeOrdinary(input2, maxContextSize);
            return encoding.decode(encodingResult.getTokens());
        }
    }
    ,
    TRUNCATED_TAIL_LOG("truncated-tail-log", "Truncates exceeded tokens from the tail of the context. Records the truncation log."){

        @Override
        public String processTokensWithLimitInternal(Encoding encoding, String input2, int maxContextSize, int actualNumTokens) {
            LOG.info("Context overflowed (threshold: {}, actual: {}), truncating the tail of input.", (Object)maxContextSize, (Object)actualNumTokens);
            EncodingResult encodingResult = encoding.encodeOrdinary(input2, maxContextSize);
            return encoding.decode(encodingResult.getTokens());
        }
    }
    ,
    TRUNCATED_HEAD("truncated-head", "Truncates exceeded tokens from the head of the context."){

        @Override
        public String processTokensWithLimitInternal(Encoding encoding, String input2, int maxContextSize, int actualNumTokens) {
            IntArrayList tokens2 = encoding.encodeOrdinary(input2);
            return encoding.decode(new HeadTrimmedIntArrayList(tokens2, tokens2.size() - maxContextSize));
        }
    }
    ,
    TRUNCATED_HEAD_LOG("truncated-head-log", "Truncates exceeded tokens from the head of the context. Records the truncation log."){

        @Override
        public String processTokensWithLimitInternal(Encoding encoding, String input2, int maxContextSize, int actualNumTokens) {
            LOG.info("Context overflowed (threshold: {}, actual: {}), truncating the head of input.", (Object)maxContextSize, (Object)actualNumTokens);
            IntArrayList tokens2 = encoding.encodeOrdinary(input2);
            return encoding.decode(new HeadTrimmedIntArrayList(tokens2, tokens2.size() - maxContextSize));
        }
    }
    ,
    SKIPPED("skipped", "Skips the input row."){

        @Override
        @Nullable
        public String processTokensWithLimitInternal(Encoding encoding, String input2, int maxContextSize, int actualNumTokens) {
            return null;
        }
    }
    ,
    SKIPPED_LOG("skipped-log", "Skips the input row. Records the skipping log."){

        @Override
        @Nullable
        public String processTokensWithLimitInternal(Encoding encoding, String input2, int maxContextSize, int actualNumTokens) {
            LOG.info("Context overflowed (threshold: {}, actual: {}), skipping input.", (Object)maxContextSize, (Object)actualNumTokens);
            return null;
        }
    };

    private static final Logger LOG;
    private static final EncodingRegistry ENCODING_REGISTRY;
    private static final Map<String, Encoding> ENCODING_MAP;
    private final String value;
    private final String description;

    private ContextOverflowAction(String value, String description2) {
        this.value = value;
        this.description = description2;
    }

    public void initializeEncodingForContextLimit(String model, @Nullable Integer maxContextSize) {
        if (maxContextSize == null) {
            return;
        }
        Optional<Encoding> optionalEncoding = Encodings.newLazyEncodingRegistry().getEncodingForModel(model);
        if (optionalEncoding.isPresent()) {
            ENCODING_MAP.putIfAbsent(model, optionalEncoding.get());
            return;
        }
        throw new IllegalArgumentException(String.format("No proper tokenizer found for model %s. Context size cannot be set.", model));
    }

    @Nullable
    public String processTokensWithLimit(String model, String input2, @Nullable Integer maxContextSize) {
        if (maxContextSize == null) {
            return input2;
        }
        Encoding encoding = ENCODING_MAP.get(model);
        int actualNumTokens = encoding.countTokensOrdinary(input2);
        if (actualNumTokens <= maxContextSize) {
            return input2;
        }
        return this.processTokensWithLimitInternal(encoding, input2, maxContextSize, actualNumTokens);
    }

    @Nullable
    abstract String processTokensWithLimitInternal(Encoding var1, String var2, int var3, int var4);

    public InlineElement getDescription() {
        return TextElement.text((String)this.description);
    }

    public String toString() {
        return this.value;
    }

    public static String getAllValuesAndDescriptions() {
        StringBuilder sb = new StringBuilder();
        int index = 1;
        for (ContextOverflowAction action : ContextOverflowAction.values()) {
            sb.append(index).append(". ").append(action.value).append(":\t").append(action.description).append("\n");
            ++index;
        }
        return sb.toString();
    }

    static {
        LOG = LoggerFactory.getLogger(ContextOverflowAction.class);
        ENCODING_REGISTRY = Encodings.newLazyEncodingRegistry();
        ENCODING_MAP = new ConcurrentHashMap<String, Encoding>();
    }

    private static class HeadTrimmedIntArrayList
    extends IntArrayList {
        private final IntArrayList delegate;
        private int headOffset;

        private HeadTrimmedIntArrayList(IntArrayList delegate, int headOffset) {
            this.delegate = delegate;
            this.headOffset = headOffset;
        }

        @Override
        public void clear() {
            this.delegate.clear();
            this.headOffset = 0;
        }

        @Override
        public void add(int element) {
            this.delegate.add(element);
        }

        @Override
        public int get(int index) {
            return this.delegate.get(index + this.headOffset);
        }

        @Override
        public int set(int index, int element) {
            return this.delegate.set(index + this.headOffset, element);
        }

        @Override
        public void ensureCapacity(int minCapacity) {
            this.delegate.ensureCapacity(minCapacity + this.headOffset);
        }

        @Override
        public int size() {
            return this.delegate.size() - this.headOffset;
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.size() == this.headOffset;
        }

        @Override
        public int[] toArray() {
            return Arrays.copyOfRange(this.delegate.toArray(), this.headOffset, this.delegate.size());
        }

        @Override
        public List<Integer> boxed() {
            return super.boxed().subList(this.headOffset, this.delegate.size());
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof HeadTrimmedIntArrayList)) {
                return false;
            }
            HeadTrimmedIntArrayList other = (HeadTrimmedIntArrayList)o;
            return Objects.equals(this.delegate, other.delegate) && this.headOffset == other.headOffset;
        }

        @Override
        public int hashCode() {
            return 31 * this.delegate.hashCode() + this.headOffset;
        }

        @Override
        public String toString() {
            return this.boxed().toString();
        }
    }
}

