/*
 * Decompiled with CFR 0.152.
 */
package com.openai.core.handlers;

import com.openai.core.http.HttpResponse;
import com.openai.errors.BadRequestException;
import com.openai.errors.InternalServerException;
import com.openai.errors.NotFoundException;
import com.openai.errors.OpenAIInvalidDataException;
import com.openai.errors.PermissionDeniedException;
import com.openai.errors.RateLimitException;
import com.openai.errors.UnauthorizedException;
import com.openai.errors.UnexpectedStatusCodeException;
import com.openai.errors.UnprocessableEntityException;
import com.openai.models.ErrorObject;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.flink.model.openai.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.json.JsonMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a.\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0001\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00012\u000e\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001H\u0000\u00a8\u0006\u0007"}, d2={"errorHandler", "Lcom/openai/core/http/HttpResponse$Handler;", "Lcom/openai/models/ErrorObject;", "jsonMapper", "Lorg/apache/flink/model/openai/com/fasterxml/jackson/databind/json/JsonMapper;", "withErrorHandler", "T", "openai-java-core"})
@JvmName(name="ErrorHandler")
@SourceDebugExtension(value={"SMAP\nErrorHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorHandler.kt\ncom/openai/core/handlers/ErrorHandler\n+ 2 JsonHandler.kt\ncom/openai/core/handlers/JsonHandler\n*L\n1#1,88:1\n13#2,8:89\n*S KotlinDebug\n*F\n+ 1 ErrorHandler.kt\ncom/openai/core/handlers/ErrorHandler\n*L\n24#1:89,8\n*E\n"})
public final class ErrorHandler {
    public static final /* synthetic */ HttpResponse.Handler errorHandler(JsonMapper jsonMapper2) {
        Intrinsics.checkNotNullParameter(jsonMapper2, "jsonMapper");
        boolean $i$f$jsonHandler = false;
        HttpResponse.Handler handler = new HttpResponse.Handler<JsonNode>(jsonMapper2){
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$jsonMapper = $jsonMapper;
            }

            public JsonNode handle(@NotNull HttpResponse response) {
                T t;
                Intrinsics.checkNotNullParameter(response, "response");
                try {
                    boolean $i$f$jacksonTypeRef = false;
                    t = this.$jsonMapper.readValue(response.body(), (TypeReference)new TypeReference<JsonNode>(){});
                }
                catch (Exception e) {
                    throw new OpenAIInvalidDataException("Error reading response", e);
                }
                return t;
            }
        };
        return new HttpResponse.Handler<ErrorObject>((HttpResponse.Handler<JsonNode>)handler, jsonMapper2){
            final /* synthetic */ HttpResponse.Handler<JsonNode> $handler;
            final /* synthetic */ JsonMapper $jsonMapper;
            {
                this.$handler = $handler;
                this.$jsonMapper = $jsonMapper;
            }

            @Nullable
            public ErrorObject handle(@NotNull HttpResponse response) {
                ErrorObject errorObject;
                Intrinsics.checkNotNullParameter(response, "response");
                try {
                    ErrorObject errorObject2;
                    JsonNode jsonNode2 = this.$handler.handle(response).get("error");
                    if (jsonNode2 != null) {
                        JsonNode jsonNode3 = jsonNode2;
                        JsonMapper jsonMapper2 = this.$jsonMapper;
                        JsonNode it = jsonNode3;
                        boolean bl = false;
                        boolean $i$f$jacksonTypeRef = false;
                        errorObject2 = (ErrorObject)jsonMapper2.readerFor(new TypeReference<ErrorObject>(){}).readValue(it);
                    } else {
                        errorObject2 = null;
                    }
                    errorObject = errorObject2;
                }
                catch (Exception e) {
                    errorObject = null;
                }
                return errorObject;
            }
        };
    }

    public static final /* synthetic */ HttpResponse.Handler withErrorHandler(HttpResponse.Handler $this$withErrorHandler, HttpResponse.Handler errorHandler2) {
        Intrinsics.checkNotNullParameter($this$withErrorHandler, "<this>");
        Intrinsics.checkNotNullParameter(errorHandler2, "errorHandler");
        return new HttpResponse.Handler<T>($this$withErrorHandler, errorHandler2){
            final /* synthetic */ HttpResponse.Handler<T> $this_withErrorHandler;
            final /* synthetic */ HttpResponse.Handler<ErrorObject> $errorHandler;
            {
                this.$this_withErrorHandler = $receiver;
                this.$errorHandler = $errorHandler;
            }

            public T handle(@NotNull HttpResponse response) {
                Intrinsics.checkNotNullParameter(response, "response");
                int statusCode = response.statusCode();
                if (!(200 <= statusCode ? statusCode < 300 : false)) {
                    if (statusCode == 400) {
                        throw BadRequestException.Companion.builder().headers(response.headers()).error(this.$errorHandler.handle(response)).build();
                    }
                    if (statusCode == 401) {
                        throw UnauthorizedException.Companion.builder().headers(response.headers()).error(this.$errorHandler.handle(response)).build();
                    }
                    if (statusCode == 403) {
                        throw PermissionDeniedException.Companion.builder().headers(response.headers()).error(this.$errorHandler.handle(response)).build();
                    }
                    if (statusCode == 404) {
                        throw NotFoundException.Companion.builder().headers(response.headers()).error(this.$errorHandler.handle(response)).build();
                    }
                    if (statusCode == 422) {
                        throw UnprocessableEntityException.Companion.builder().headers(response.headers()).error(this.$errorHandler.handle(response)).build();
                    }
                    if (statusCode == 429) {
                        throw RateLimitException.Companion.builder().headers(response.headers()).error(this.$errorHandler.handle(response)).build();
                    }
                    boolean bl = 500 <= statusCode ? statusCode < 600 : false;
                    if (bl) {
                        throw InternalServerException.Companion.builder().statusCode(statusCode).headers(response.headers()).error(this.$errorHandler.handle(response)).build();
                    }
                    throw UnexpectedStatusCodeException.Companion.builder().statusCode(statusCode).headers(response.headers()).error(this.$errorHandler.handle(response)).build();
                }
                return this.$this_withErrorHandler.handle(response);
            }
        };
    }
}

