/*
 * Decompiled with CFR 0.152.
 */
package com.knuddels.jtokkit;

import com.knuddels.jtokkit.ByteArrayList;
import com.knuddels.jtokkit.SpecialEncoder;
import com.knuddels.jtokkit.TokenEncoder;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingResult;
import com.knuddels.jtokkit.api.GptBytePairEncodingParams;
import com.knuddels.jtokkit.api.IntArrayList;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GptBytePairEncoding
implements Encoding {
    final TokenEncoder encoder;
    private final String name;
    private final Pattern pattern;
    private final SpecialEncoder specialEncoder;

    GptBytePairEncoding(GptBytePairEncodingParams params) {
        this.name = params.getName();
        this.pattern = params.getPattern();
        this.encoder = new TokenEncoder(params.getEncoder());
        this.specialEncoder = new SpecialEncoder(params.getSpecialTokensEncoder());
    }

    @Override
    public IntArrayList encode(String text) {
        return this.encode(text, Integer.MAX_VALUE).getTokens();
    }

    @Override
    public EncodingResult encode(String text, int maxTokenCount) {
        return this.encodeInternal(text, maxTokenCount, true).toEncodingResult();
    }

    private InternalResult encodeInternal(String text, int maxTokenCount, boolean keepEncodings) {
        if (text == null) {
            return new InternalResult(new IntArrayList(0), -1, false, -1);
        }
        this.specialEncoder.checkForSpecialTokens(text);
        return this.encodeOrdinaryInternal(text, maxTokenCount, keepEncodings);
    }

    @Override
    public IntArrayList encodeOrdinary(String text) {
        return this.encodeOrdinary(text, Integer.MAX_VALUE).getTokens();
    }

    @Override
    public EncodingResult encodeOrdinary(String text, int maxTokenCount) {
        return this.encodeOrdinaryInternal(text, maxTokenCount, true).toEncodingResult();
    }

    private InternalResult encodeOrdinaryInternal(String text, int maxTokenCount, boolean keepEncodings) {
        if (text == null) {
            return new InternalResult(new IntArrayList(0), -1, false, -1);
        }
        IntArrayList out = new IntArrayList();
        int tokenCount = this.encodeOrdinaryInternal(text, maxTokenCount, keepEncodings, out);
        if (keepEncodings && maxTokenCount != Integer.MAX_VALUE) {
            for (int tokensToRemove = 0; tokensToRemove <= out.size(); ++tokensToRemove) {
                int size = out.size() - tokensToRemove;
                IntArrayList tokens2 = new IntArrayList(size);
                for (int i = 0; i < size; ++i) {
                    tokens2.add(out.get(i));
                }
                String decoded = this.decode(tokens2);
                if (!text.startsWith(decoded)) continue;
                return new InternalResult(tokens2, -1, text.length() > decoded.length(), decoded.length() - 1);
            }
        }
        return new InternalResult(out, tokenCount, false, text.length() - 1);
    }

    int encodeOrdinaryInternal(String text, int maxTokenCount, boolean keepEncodings, IntArrayList out) {
        int tokenCount;
        byte[] bytes2;
        IntArrayList ranks = new IntArrayList();
        Matcher matcher = this.pattern.matcher(text);
        for (tokenCount = 0; tokenCount < maxTokenCount && matcher.find(); tokenCount += this.encoder.addTokensAndGetCount(maxTokenCount, keepEncodings, bytes2, out, ranks)) {
            bytes2 = matcher.group().getBytes(StandardCharsets.UTF_8);
        }
        return tokenCount;
    }

    @Override
    public int countTokens(String text) {
        return this.encodeInternal(text, Integer.MAX_VALUE, false).toTokenCount();
    }

    @Override
    public int countTokensOrdinary(String text) {
        return this.encodeOrdinaryInternal(text, Integer.MAX_VALUE, false).toTokenCount();
    }

    @Override
    public String decode(IntArrayList tokens2) {
        return new String(this.decodeBytes(tokens2), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] decodeBytes(IntArrayList tokens2) {
        ByteArrayList out = new ByteArrayList(10 * tokens2.size());
        for (int i = 0; i < tokens2.size(); ++i) {
            byte[] decodedToken;
            for (byte b : decodedToken = this.decodeToken(tokens2.get(i))) {
                out.add(b);
            }
        }
        return out.toArray();
    }

    @Override
    public String getName() {
        return this.name;
    }

    private byte[] decodeToken(int token) {
        byte[] decodedToken = this.encoder.decodeToken(token, this.specialEncoder);
        return Objects.requireNonNull(decodedToken, "Unknown token for decoding: " + token);
    }

    private static final class InternalResult {
        private final IntArrayList tokens;
        private final boolean truncated;
        private final int tokenCount;
        private final int lastProcessedCharacterIndex;

        private InternalResult(IntArrayList tokens2, int tokenCount, boolean truncated, int lastProcessedCharacterIndex) {
            this.tokens = tokens2;
            this.truncated = truncated;
            this.tokenCount = tokenCount < 0 ? tokens2.size() : tokenCount;
            this.lastProcessedCharacterIndex = lastProcessedCharacterIndex;
        }

        private EncodingResult toEncodingResult() {
            if (this.tokens.size() != this.tokenCount) {
                throw new IllegalStateException("Token count does not match token list size (tokenCount=" + this.tokenCount + ", tokens size=" + this.tokens.size() + ")");
            }
            return new EncodingResult(this.tokens, this.truncated, this.lastProcessedCharacterIndex);
        }

        private int toTokenCount() {
            return this.tokenCount;
        }
    }
}

