/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseContent
implements HttpResponseInterceptor {
    private final boolean overwrite;

    public ResponseContent() {
        this(false);
    }

    public ResponseContent(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public void process(HttpResponse response, EntityDetails entity2, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        if (this.overwrite) {
            response.removeHeaders("Transfer-Encoding");
            response.removeHeaders("Content-Length");
        } else {
            if (response.containsHeader("Transfer-Encoding")) {
                throw new ProtocolException("Transfer-encoding header already present");
            }
            if (response.containsHeader("Content-Length")) {
                throw new ProtocolException("Content-Length header already present");
            }
        }
        ProtocolVersion ver = context.getProtocolVersion();
        if (entity2 != null) {
            long len = entity2.getContentLength();
            if (len >= 0L && !entity2.isChunked()) {
                response.addHeader("Content-Length", Long.toString(entity2.getContentLength()));
            } else if (ver.greaterEquals(HttpVersion.HTTP_1_1)) {
                response.addHeader("Transfer-Encoding", "chunked");
                MessageSupport.addTrailerHeader(response, entity2);
            }
            MessageSupport.addContentTypeHeader(response, entity2);
            MessageSupport.addContentEncodingHeader(response, entity2);
        } else {
            int status = response.getCode();
            if (status != 204 && status != 304) {
                response.addHeader("Content-Length", "0");
            }
        }
    }
}

