/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.model.openai.com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_2;

import java.math.BigInteger;
import java.util.NavigableMap;
import org.apache.flink.model.openai.com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_2.AbstractBigIntegerParser;
import org.apache.flink.model.openai.com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_2.AbstractNumberParser;
import org.apache.flink.model.openai.com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_2.FastDoubleSwar;
import org.apache.flink.model.openai.com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_2.FastIntegerMath;
import org.apache.flink.model.openai.com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_2.ParseDigitsTaskCharSequence;

class JavaBigIntegerFromCharSequence
extends AbstractBigIntegerParser {
    JavaBigIntegerFromCharSequence() {
    }

    public BigInteger parseBigIntegerString(CharSequence str, int offset, int length, int radix) throws NumberFormatException {
        try {
            boolean isNegative;
            int size = str.length();
            int endIndex = AbstractNumberParser.checkBounds(size, offset, length);
            int index = offset;
            char ch = str.charAt(index);
            boolean bl = isNegative = ch == '-';
            if ((isNegative || ch == '+') && (ch = JavaBigIntegerFromCharSequence.charAt(str, ++index, endIndex)) == '\u0000') {
                throw new NumberFormatException("illegal syntax");
            }
            switch (radix) {
                case 10: {
                    return this.parseDecDigits(str, index, endIndex, isNegative);
                }
                case 16: {
                    return this.parseHexDigits(str, index, endIndex, isNegative);
                }
            }
            return new BigInteger(str.subSequence(offset, length).toString(), radix);
        }
        catch (ArithmeticException e) {
            NumberFormatException nfe = new NumberFormatException("value exceeds limits");
            nfe.initCause(e);
            throw nfe;
        }
    }

    private BigInteger parseDecDigits(CharSequence str, int from2, int to, boolean isNegative) {
        int numDigits = to - from2;
        if (JavaBigIntegerFromCharSequence.hasManyDigits(numDigits)) {
            return this.parseManyDecDigits(str, from2, to, isNegative);
        }
        int preroll = from2 + (numDigits & 7);
        long significand = FastDoubleSwar.tryToParseUpTo7Digits(str, from2, preroll);
        boolean success = significand >= 0L;
        for (from2 = preroll; from2 < to; from2 += 8) {
            int addend = FastDoubleSwar.tryToParseEightDigits(str, from2);
            success &= addend >= 0;
            significand = significand * 100000000L + (long)addend;
        }
        if (!success) {
            throw new NumberFormatException("illegal syntax");
        }
        return BigInteger.valueOf(isNegative ? -significand : significand);
    }

    private BigInteger parseHexDigits(CharSequence str, int from2, int to, boolean isNegative) {
        int numDigits = to - (from2 = this.skipZeroes(str, from2, to));
        if (numDigits <= 0) {
            return BigInteger.ZERO;
        }
        JavaBigIntegerFromCharSequence.checkHexBigIntegerBounds(numDigits);
        byte[] bytes2 = new byte[(numDigits + 1 >> 1) + 1];
        int index = 1;
        boolean illegalDigits = false;
        if ((numDigits & 1) != 0) {
            char chLow = str.charAt(from2++);
            int valueLow = JavaBigIntegerFromCharSequence.lookupHex(chLow);
            bytes2[index++] = (byte)valueLow;
            illegalDigits = valueLow < 0;
        }
        int prerollLimit = from2 + (to - from2 & 7);
        while (from2 < prerollLimit) {
            char chHigh = str.charAt(from2);
            char chLow = str.charAt(from2 + 1);
            int valueHigh = JavaBigIntegerFromCharSequence.lookupHex(chHigh);
            int valueLow = JavaBigIntegerFromCharSequence.lookupHex(chLow);
            bytes2[index++] = (byte)(valueHigh << 4 | valueLow);
            illegalDigits |= valueLow < 0 || valueHigh < 0;
            from2 += 2;
        }
        while (from2 < to) {
            long value = FastDoubleSwar.tryToParseEightHexDigits(str, from2);
            FastDoubleSwar.writeIntBE(bytes2, index, (int)value);
            illegalDigits |= value < 0L;
            from2 += 8;
            index += 4;
        }
        if (illegalDigits) {
            throw new NumberFormatException("illegal syntax");
        }
        BigInteger result = new BigInteger(bytes2);
        return isNegative ? result.negate() : result;
    }

    private BigInteger parseManyDecDigits(CharSequence str, int from2, int to, boolean isNegative) {
        from2 = this.skipZeroes(str, from2, to);
        int numDigits = to - from2;
        JavaBigIntegerFromCharSequence.checkDecBigIntegerBounds(numDigits);
        NavigableMap<Integer, BigInteger> powersOfTen = FastIntegerMath.fillPowersOf10Floor16(from2, to);
        BigInteger result = ParseDigitsTaskCharSequence.parseDigitsRecursive(str, from2, to, powersOfTen, 400);
        return isNegative ? result.negate() : result;
    }

    private int skipZeroes(CharSequence str, int from2, int to) {
        while (from2 < to && str.charAt(from2) == '0') {
            ++from2;
        }
        return from2;
    }
}

