/*
 * Decompiled with CFR 0.152.
 */
package com.openai.core.http;

import com.openai.core.MultipartField;
import com.openai.core.http.HttpRequestBodies;
import com.openai.core.http.HttpRequestBody;
import com.openai.errors.OpenAIInvalidDataException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.json.JsonMapper;
import org.apache.flink.model.openai.com.fasterxml.jackson.databind.node.JsonNodeType;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u0001\"\u0006\b\u0000\u0010\u0002\u0018\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u0002H\u0002H\u0080\b\u00a2\u0006\u0002\u0010\u0006\u001a(\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tH\u0000\u00a8\u0006\f"}, d2={"json", "Lcom/openai/core/http/HttpRequestBody;", "T", "jsonMapper", "Lorg/apache/flink/model/openai/com/fasterxml/jackson/databind/json/JsonMapper;", "value", "(Lcom/fasterxml/jackson/databind/json/JsonMapper;Ljava/lang/Object;)Lcom/openai/core/http/HttpRequestBody;", "multipartFormData", "fields", "", "", "Lcom/openai/core/MultipartField;", "openai-java-core"})
@JvmName(name="HttpRequestBodies")
public final class HttpRequestBodies {
    public static final /* synthetic */ <T> HttpRequestBody json(JsonMapper jsonMapper2, T value) {
        Intrinsics.checkNotNullParameter(jsonMapper2, "jsonMapper");
        boolean $i$f$json = false;
        return new HttpRequestBody(jsonMapper2, value){
            @NotNull
            private final Lazy bytes$delegate;
            {
                this.bytes$delegate = LazyKt.lazy((Function0)new Function0<byte[]>($jsonMapper, $value){
                    final /* synthetic */ JsonMapper $jsonMapper;
                    final /* synthetic */ T $value;
                    {
                        this.$jsonMapper = $jsonMapper;
                        this.$value = $value;
                        super(0);
                    }

                    public final byte[] invoke() {
                        return this.$jsonMapper.writeValueAsBytes(this.$value);
                    }
                });
            }

            private final byte[] getBytes() {
                Lazy lazy = this.bytes$delegate;
                T t = lazy.getValue();
                Intrinsics.checkNotNullExpressionValue(t, "<get-bytes>(...)");
                return (byte[])t;
            }

            public void writeTo(@NotNull OutputStream outputStream2) {
                Intrinsics.checkNotNullParameter(outputStream2, "outputStream");
                outputStream2.write(this.getBytes());
            }

            @NotNull
            public String contentType() {
                return "application/json";
            }

            public long contentLength() {
                return this.getBytes().length;
            }

            public boolean repeatable() {
                return true;
            }

            public void close() {
            }
        };
    }

    public static final /* synthetic */ HttpRequestBody multipartFormData(JsonMapper jsonMapper2, Map fields2) {
        Intrinsics.checkNotNullParameter(jsonMapper2, "jsonMapper");
        Intrinsics.checkNotNullParameter(fields2, "fields");
        return new HttpRequestBody(fields2, jsonMapper2){
            @NotNull
            private final Lazy entity$delegate;
            {
                this.entity$delegate = LazyKt.lazy((Function0)new Function0<HttpEntity>($fields, $jsonMapper, this){
                    final /* synthetic */ Map<String, MultipartField<?>> $fields;
                    final /* synthetic */ JsonMapper $jsonMapper;
                    final /* synthetic */ multipartFormData.1 this$0;
                    {
                        this.$fields = $fields;
                        this.$jsonMapper = $jsonMapper;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final HttpEntity invoke() {
                        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
                        Map<String, MultipartField<?>> map2 = this.$fields;
                        JsonMapper jsonMapper2 = this.$jsonMapper;
                        multipartFormData.1 var4_4 = this.this$0;
                        MultipartEntityBuilder $this$invoke_u24lambda_u242 = multipartEntityBuilder;
                        boolean bl = false;
                        Map<String, MultipartField<?>> $this$forEach$iv = map2;
                        boolean $i$f$forEach = false;
                        Iterator<Map.Entry<String, MultipartField<?>>> iterator2 = $this$forEach$iv.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Sequence parts2;
                            Sequence sequence2;
                            Map.Entry<String, MultipartField<?>> element$iv;
                            Map.Entry<String, MultipartField<?>> entry = element$iv = iterator2.next();
                            boolean bl2 = false;
                            String name = entry.getKey();
                            MultipartField<?> field = entry.getValue();
                            ? knownValue = OptionalsKt.getOrNull(field.value().asKnown());
                            if (knownValue instanceof InputStream) {
                                Pair[] pairArray = new Pair[]{TuplesKt.to(name, knownValue)};
                                sequence2 = SequencesKt.sequenceOf(pairArray);
                            } else {
                                T node = jsonMapper2.valueToTree(field.value());
                                Intrinsics.checkNotNullExpressionValue(node, "node");
                                sequence2 = multipartFormData.1.access$serializePart(var4_4, name, node);
                            }
                            Sequence $this$forEach$iv2 = parts2 = sequence2;
                            boolean $i$f$forEach2 = false;
                            Iterator<T> iterator3 = $this$forEach$iv2.iterator();
                            while (iterator3.hasNext()) {
                                T element$iv2 = iterator3.next();
                                Pair pair = (Pair)element$iv2;
                                boolean bl3 = false;
                                String name2 = (String)pair.component1();
                                InputStream bytes2 = (InputStream)pair.component2();
                                $this$invoke_u24lambda_u242.addBinaryBody(name2, bytes2, ContentType.parseLenient(field.contentType()), OptionalsKt.getOrNull(field.filename()));
                            }
                        }
                        return multipartEntityBuilder.build();
                    }
                });
            }

            private final HttpEntity getEntity() {
                Lazy lazy = this.entity$delegate;
                T t = lazy.getValue();
                Intrinsics.checkNotNullExpressionValue(t, "<get-entity>(...)");
                return (HttpEntity)t;
            }

            private final Sequence<Pair<String, InputStream>> serializePart(String name, JsonNode node) {
                Sequence<Pair<String, InputStream>> sequence2;
                JsonNodeType jsonNodeType = node.getNodeType();
                switch (jsonNodeType == null ? -1 : multipartFormData.WhenMappings.$EnumSwitchMapping$0[jsonNodeType.ordinal()]) {
                    case 1: 
                    case 2: {
                        sequence2 = SequencesKt.emptySequence();
                        break;
                    }
                    case 3: {
                        Pair[] pairArray = new Pair[1];
                        byte[] byArray = node.binaryValue();
                        Intrinsics.checkNotNullExpressionValue(byArray, "node.binaryValue()");
                        byte[] byArray2 = byArray;
                        pairArray[0] = TuplesKt.to(name, new ByteArrayInputStream(byArray2));
                        sequence2 = SequencesKt.sequenceOf(pairArray);
                        break;
                    }
                    case 4: {
                        Pair[] pairArray = new Pair[1];
                        String string = node.textValue();
                        Intrinsics.checkNotNullExpressionValue(string, "node.textValue()");
                        pairArray[0] = TuplesKt.to(name, this.inputStream(string));
                        sequence2 = SequencesKt.sequenceOf(pairArray);
                        break;
                    }
                    case 5: {
                        Pair[] pairArray = new Pair[]{TuplesKt.to(name, this.inputStream(String.valueOf(node.booleanValue())))};
                        sequence2 = SequencesKt.sequenceOf(pairArray);
                        break;
                    }
                    case 6: {
                        Pair[] pairArray = new Pair[]{TuplesKt.to(name, this.inputStream(node.numberValue().toString()))};
                        sequence2 = SequencesKt.sequenceOf(pairArray);
                        break;
                    }
                    case 7: {
                        Iterator<JsonNode> iterator2 = node.elements();
                        Intrinsics.checkNotNullExpressionValue(iterator2, "node.elements()");
                        sequence2 = SequencesKt.flatMap(SequencesKt.asSequence(iterator2), (Function1)new Function1<JsonNode, Sequence<? extends Pair<? extends String, ? extends InputStream>>>(this, name){
                            final /* synthetic */ multipartFormData.1 this$0;
                            final /* synthetic */ String $name;
                            {
                                this.this$0 = $receiver;
                                this.$name = $name;
                                super(1);
                            }

                            @NotNull
                            public final Sequence<Pair<String, InputStream>> invoke(JsonNode element) {
                                String string = this.$name + "[]";
                                Intrinsics.checkNotNullExpressionValue(element, "element");
                                return multipartFormData.1.access$serializePart(this.this$0, string, element);
                            }
                        });
                        break;
                    }
                    case 8: {
                        Iterator<Map.Entry<String, JsonNode>> iterator3 = node.fields();
                        Intrinsics.checkNotNullExpressionValue(iterator3, "node.fields()");
                        sequence2 = SequencesKt.flatMap(SequencesKt.asSequence(iterator3), (Function1)new Function1<Map.Entry<String, JsonNode>, Sequence<? extends Pair<? extends String, ? extends InputStream>>>(this, name){
                            final /* synthetic */ multipartFormData.1 this$0;
                            final /* synthetic */ String $name;
                            {
                                this.this$0 = $receiver;
                                this.$name = $name;
                                super(1);
                            }

                            @NotNull
                            public final Sequence<Pair<String, InputStream>> invoke(Map.Entry<String, JsonNode> entry) {
                                Intrinsics.checkNotNullExpressionValue(entry, "(key, value)");
                                String key = entry.getKey();
                                JsonNode value = entry.getValue();
                                String string = this.$name + '[' + key + ']';
                                Intrinsics.checkNotNullExpressionValue(value, "value");
                                return multipartFormData.1.access$serializePart(this.this$0, string, value);
                            }
                        });
                        break;
                    }
                    case -1: 
                    case 9: {
                        throw new OpenAIInvalidDataException("Unexpected JsonNode type: " + (Object)((Object)node.getNodeType()), null, 2, null);
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return sequence2;
            }

            private final InputStream inputStream(String $this$inputStream) {
                Object object = $this$inputStream;
                byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
                object = byArray;
                return new ByteArrayInputStream((byte[])object);
            }

            public void writeTo(@NotNull OutputStream outputStream2) {
                Intrinsics.checkNotNullParameter(outputStream2, "outputStream");
                this.getEntity().writeTo(outputStream2);
            }

            @NotNull
            public String contentType() {
                String string = this.getEntity().getContentType();
                Intrinsics.checkNotNullExpressionValue(string, "entity.contentType");
                return string;
            }

            public long contentLength() {
                return this.getEntity().getContentLength();
            }

            public boolean repeatable() {
                return this.getEntity().isRepeatable();
            }

            public void close() {
                this.getEntity().close();
            }

            public static final /* synthetic */ Sequence access$serializePart(multipartFormData.1 $this, String name, JsonNode node) {
                return $this.serializePart(name, node);
            }
        };
    }
}

