/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.migration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.FlinkVersion;
import org.apache.flink.test.util.MigrationTest;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.ExternalResource;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.Parameterized;
import org.junit.runners.model.Statement;

class SnapshotGeneratorUtils {
    SnapshotGeneratorUtils() {
    }

    static void executeGenerate(Class<?> migrationTestClass, FlinkVersion flinkVersion) throws Throwable {
        for (Method method : migrationTestClass.getMethods()) {
            if (method.isAnnotationPresent(MigrationTest.SnapshotsGenerator.class)) {
                SnapshotGeneratorUtils.executeGenerateMethods(migrationTestClass, method, flinkVersion);
                continue;
            }
            if (!method.isAnnotationPresent(MigrationTest.ParameterizedSnapshotsGenerator.class)) continue;
            String parametersMethodName = method.getAnnotation(MigrationTest.ParameterizedSnapshotsGenerator.class).value();
            Method parametersMethod = migrationTestClass.getMethod(parametersMethodName, FlinkVersion.class);
            SnapshotGeneratorUtils.executeParameterizedGenerateMethods(migrationTestClass, method, parametersMethod, flinkVersion);
        }
    }

    private static void executeGenerateMethods(final Class<?> migrationTestClass, final Method method, final FlinkVersion version) throws Throwable {
        method.setAccessible(true);
        List<TestRule> classRules = SnapshotGeneratorUtils.getRuleFields(migrationTestClass, ClassRule.class, null);
        SnapshotGeneratorUtils.executeWithRules(classRules, new Statement(){

            public void evaluate() throws Throwable {
                final Object migrationTest = SnapshotGeneratorUtils.createMigrationTest(migrationTestClass);
                List<TestRule> rules = SnapshotGeneratorUtils.getRuleFields(migrationTestClass, Rule.class, migrationTest);
                SnapshotGeneratorUtils.executeWithRules(rules, new Statement(){

                    public void evaluate() throws Throwable {
                        method.invoke(migrationTest, version);
                    }
                });
            }
        });
    }

    private static void executeParameterizedGenerateMethods(final Class<?> migrationTestClass, final Method method, final Method parametersMethod, final FlinkVersion version) throws Throwable {
        method.setAccessible(true);
        parametersMethod.setAccessible(true);
        List<TestRule> classRules = SnapshotGeneratorUtils.getRuleFields(migrationTestClass, ClassRule.class, null);
        SnapshotGeneratorUtils.executeWithRules(classRules, new Statement(){

            public void evaluate() throws Throwable {
                final Object migrationTest = SnapshotGeneratorUtils.createMigrationTest(migrationTestClass);
                List<TestRule> rules = SnapshotGeneratorUtils.getRuleFields(migrationTestClass, Rule.class, migrationTest);
                Collection arguments = (Collection)parametersMethod.invoke(migrationTest, version);
                for (final Object argument : arguments) {
                    SnapshotGeneratorUtils.executeWithRules(rules, new Statement(){

                        public void evaluate() throws Throwable {
                            method.invoke(migrationTest, argument);
                        }
                    });
                }
            }
        });
    }

    private static void executeWithRules(List<TestRule> rules, Statement statement) throws Throwable {
        new RunRules(statement, rules, Description.EMPTY).evaluate();
    }

    private static List<TestRule> getRuleFields(Class<?> migrationTestClass, Class<? extends Annotation> tagClass, Object migrationTest) throws IllegalAccessException {
        Field[] fields;
        ArrayList<TestRule> rules = new ArrayList<TestRule>();
        for (Field field : fields = migrationTestClass.getFields()) {
            if (!ExternalResource.class.isAssignableFrom(field.getType()) || !field.isAnnotationPresent(tagClass)) continue;
            field.setAccessible(true);
            rules.add((TestRule)((ExternalResource)field.get(migrationTest)));
        }
        return rules;
    }

    private static Object createMigrationTest(Class<?> migrationTestClass) throws Exception {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = migrationTestClass.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        Constructor<?> constructor = constructors[0];
        constructor.setAccessible(true);
        System.out.println("create test!!!");
        for (Method method : migrationTestClass.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !method.isAnnotationPresent(Parameterized.Parameters.class) && !method.isAnnotationPresent(Parameters.class)) continue;
            System.out.println("ffffffff!!!!");
            Object argumentLists = method.invoke(null, new Object[0]);
            if (argumentLists instanceof Collection) {
                return constructor.newInstance(((Collection)argumentLists).iterator().next());
            }
            if (argumentLists.getClass().isArray()) {
                return constructor.newInstance(Array.get(argumentLists, 0));
            }
            throw new RuntimeException("Failed to create parameterized class object due to argument lists type not supported: " + argumentLists.getClass());
        }
        throw new RuntimeException("Could not create the object for " + migrationTestClass + ": No default constructor or @Parameterized.Parameters or @Parameters method found.");
    }
}

