/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.model.jackson;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.function.BooleanSupplier;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.PropertyName;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.deser.NullValueProvider;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.exc.MismatchedInputException;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.util.NameTransformer;

public class SettableBeanPropertyDelegating
extends SettableBeanProperty.Delegating {
    private final SettableAnyProperty anySetter;
    private final transient BooleanSupplier useAnySetter;

    SettableBeanPropertyDelegating(SettableBeanProperty delegate, SettableAnyProperty anySetter, BooleanSupplier useAnySetter) {
        super(delegate);
        this.anySetter = anySetter;
        this.useAnySetter = useAnySetter;
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty d) {
        return new SettableBeanPropertyDelegating(d, this.anySetter, this.useAnySetter);
    }

    @Override
    public void markAsIgnorable() {
        this.delegate.markAsIgnorable();
    }

    @Override
    public boolean isIgnorable() {
        return this.delegate.isIgnorable();
    }

    @Override
    public void setViews(Class<?>[] views) {
        this.delegate.setViews(views);
    }

    @Override
    public <A extends Annotation> A getContextAnnotation(Class<A> acls) {
        return this.delegate.getContextAnnotation(acls);
    }

    @Override
    public PropertyName getWrapperName() {
        return this.delegate.getWrapperName();
    }

    @Override
    public NullValueProvider getNullValueProvider() {
        return this.delegate.getNullValueProvider();
    }

    @Override
    public void depositSchemaProperty(JsonObjectFormatVisitor objectVisitor, SerializerProvider provider) throws JsonMappingException {
        this.delegate.depositSchemaProperty(objectVisitor, provider);
    }

    @Override
    public JavaType getType() {
        return this.delegate.getType();
    }

    @Override
    public PropertyName getFullName() {
        return this.delegate.getFullName();
    }

    @Override
    public void setManagedReferenceName(String n) {
        this.delegate.setManagedReferenceName(n);
    }

    @Override
    public SettableBeanProperty withSimpleName(String simpleName) {
        return this._with(this.delegate.withSimpleName(simpleName));
    }

    public SettableBeanProperty unwrapped(NameTransformer unwrapper) {
        return this._with(this.delegate.unwrapped(unwrapper));
    }

    @Override
    public void setObjectIdInfo(ObjectIdInfo objectIdInfo) {
        this.delegate.setObjectIdInfo(objectIdInfo);
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        try {
            this.delegate.deserializeAndSet(p, ctxt, instance);
        }
        catch (MismatchedInputException ex) {
            if (this.shouldUseAnySetter()) {
                this.anySetter.set(instance, this.delegate.getName(), p.getText());
            }
            throw ex;
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        try {
            return this.delegate.deserializeSetAndReturn(p, ctxt, instance);
        }
        catch (MismatchedInputException ex) {
            this.deserializeAndSet(p, ctxt, instance);
            return instance;
        }
    }

    private boolean shouldUseAnySetter() {
        if (this.anySetter == null) {
            return false;
        }
        return this.useAnySetter.getAsBoolean();
    }
}

