/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.ExponentialBackoffIntervalCalculator;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.Utils;

public class AsyncUtils {
    private AsyncUtils() {
    }

    public static <T> CompletableFuture<T> withTimeout(CompletableFuture<T> future, Duration timeout) {
        if (timeout != null && timeout.toMillis() > 0L) {
            CompletableFuture<Void> scheduled = Utils.schedule(Runnable::run, () -> future.completeExceptionally(new TimeoutException()), timeout.toMillis(), TimeUnit.MILLISECONDS);
            future.whenComplete((v, t) -> scheduled.cancel(true));
        }
        return future;
    }

    public static <T> CompletableFuture<T> retryWithExponentialBackoff(Supplier<CompletableFuture<T>> action, Consumer<T> onCancel, Duration timeout, ExponentialBackoffIntervalCalculator retryIntervalCalculator, ShouldRetry<T> shouldRetry) {
        CompletableFuture result = new CompletableFuture();
        AsyncUtils.retryWithExponentialBackoff(result, action, onCancel, timeout, retryIntervalCalculator, shouldRetry);
        return result;
    }

    private static <T> void retryWithExponentialBackoff(CompletableFuture<T> result, Supplier<CompletableFuture<T>> action, Consumer<T> onCancel, Duration timeout, ExponentialBackoffIntervalCalculator retryIntervalCalculator, ShouldRetry<T> shouldRetry) {
        AsyncUtils.withTimeout(action.get(), timeout).whenComplete((r, t) -> {
            long retryInterval;
            long retryValue;
            if (retryIntervalCalculator.shouldRetry() && !result.isDone() && (retryValue = shouldRetry.shouldRetry((Object)r, (Throwable)t, retryInterval = retryIntervalCalculator.nextReconnectInterval())) >= 0L) {
                if (r != null) {
                    onCancel.accept(r);
                }
                Utils.schedule(Runnable::run, () -> AsyncUtils.lambda$retryWithExponentialBackoff$2(result, (Supplier)action, onCancel, timeout, retryIntervalCalculator, shouldRetry), retryInterval, TimeUnit.MILLISECONDS);
                return;
            }
            if (t != null) {
                result.completeExceptionally((Throwable)t);
            } else if (!result.complete(r)) {
                onCancel.accept(r);
            }
        });
    }

    private static /* synthetic */ void lambda$retryWithExponentialBackoff$2(CompletableFuture result, Supplier action, Consumer onCancel, Duration timeout, ExponentialBackoffIntervalCalculator retryIntervalCalculator, ShouldRetry shouldRetry) {
        AsyncUtils.retryWithExponentialBackoff(result, action, onCancel, timeout, retryIntervalCalculator, shouldRetry);
    }

    @FunctionalInterface
    public static interface ShouldRetry<T> {
        public long shouldRetry(T var1, Throwable var2, long var3);
    }
}

