/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.core.v1;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Container;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ReplicationController;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ReplicationControllerList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Status;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.Client;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.KubernetesClientException;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.BytesLimitTerminateTimeTailPrettyLoggable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.LogWatch;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.Loggable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.PodResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.TailPrettyLoggable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.TimeTailPrettyLoggable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplacePatchable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollableScalableResourceOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollingUpdater;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.core.v1.ReplicationControllerRollingUpdater;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.internal.PodOperationUtil;

public class ReplicationControllerOperationsImpl
extends RollableScalableResourceOperation<ReplicationController, ReplicationControllerList, RollableScalableResource<ReplicationController>>
implements TimeoutImageEditReplacePatchable<ReplicationController> {
    public ReplicationControllerOperationsImpl(Client client) {
        this(new PodOperationContext(), HasMetadataOperationsImpl.defaultContext(client));
    }

    public ReplicationControllerOperationsImpl(PodOperationContext context, OperationContext superContext) {
        super(context, superContext.withPlural("replicationcontrollers"), ReplicationController.class, ReplicationControllerList.class);
    }

    @Override
    public ReplicationControllerOperationsImpl newInstance(OperationContext context) {
        return new ReplicationControllerOperationsImpl(this.rollingOperationContext, context);
    }

    public ReplicationControllerOperationsImpl newInstance(PodOperationContext context, OperationContext superContext) {
        return new ReplicationControllerOperationsImpl(context, superContext);
    }

    @Override
    public RollingUpdater<ReplicationController, ReplicationControllerList> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new ReplicationControllerRollingUpdater(this.context.getClient(), this.namespace, rollingTimeUnit.toMillis(rollingTimeout), this.getRequestConfig().getLoggingInterval().intValue());
    }

    @Override
    public Status rollback(DeploymentRollback deploymentRollback) {
        throw new KubernetesClientException("rollback not supported in case of ReplicationControllers");
    }

    @Override
    public String getLog(boolean isPretty) {
        return PodOperationUtil.getLog(new ReplicationControllerOperationsImpl(this.rollingOperationContext.withPrettyOutput(isPretty), this.context).doGetLog(), isPretty);
    }

    private List<PodResource> doGetLog() {
        ReplicationController rc = (ReplicationController)this.requireFromServer();
        return PodOperationUtil.getPodOperationsForController(this.context, this.rollingOperationContext, rc.getMetadata().getUid(), ReplicationControllerOperationsImpl.getReplicationControllerPodLabels(rc));
    }

    @Override
    public Reader getLogReader() {
        return PodOperationUtil.getLogReader(this.doGetLog());
    }

    @Override
    public InputStream getLogInputStream() {
        return PodOperationUtil.getLogInputStream(this.doGetLog());
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        return PodOperationUtil.watchLog(this.doGetLog(), out);
    }

    static Map<String, String> getReplicationControllerPodLabels(ReplicationController replicationController) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (replicationController != null && replicationController.getSpec() != null && replicationController.getSpec().getSelector() != null) {
            labels.putAll(replicationController.getSpec().getSelector());
        }
        return labels;
    }

    @Override
    protected List<Container> getContainers(ReplicationController value) {
        return value.getSpec().getTemplate().getSpec().getContainers();
    }

    @Override
    public TimeTailPrettyLoggable limitBytes(int limitBytes) {
        return new ReplicationControllerOperationsImpl(this.rollingOperationContext.withLimitBytes(limitBytes), this.context);
    }

    @Override
    public TimeTailPrettyLoggable terminated() {
        return new ReplicationControllerOperationsImpl(this.rollingOperationContext.withTerminatedStatus(true), this.context);
    }

    @Override
    public Loggable withPrettyOutput() {
        return new ReplicationControllerOperationsImpl(this.rollingOperationContext.withPrettyOutput(true), this.context);
    }

    @Override
    public PrettyLoggable tailingLines(int lines) {
        return new ReplicationControllerOperationsImpl(this.rollingOperationContext.withTailingLines(lines), this.context);
    }

    @Override
    public TailPrettyLoggable sinceTime(String timestamp) {
        return new ReplicationControllerOperationsImpl(this.rollingOperationContext.withSinceTimestamp(timestamp), this.context);
    }

    @Override
    public TailPrettyLoggable sinceSeconds(int seconds) {
        return new ReplicationControllerOperationsImpl(this.rollingOperationContext.withSinceSeconds(seconds), this.context);
    }

    @Override
    public BytesLimitTerminateTimeTailPrettyLoggable usingTimestamps() {
        return new ReplicationControllerOperationsImpl(this.rollingOperationContext.withTimestamps(true), this.context);
    }
}

