/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.storage.v1beta1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeDriver;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.storage.v1beta1.VolumeNodeResources;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.storage.v1beta1.VolumeNodeResourcesBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.storage.v1beta1.VolumeNodeResourcesFluent;

public class CSINodeDriverFluent<A extends CSINodeDriverFluent<A>>
extends BaseFluent<A> {
    private VolumeNodeResourcesBuilder allocatable;
    private String name;
    private String nodeID;
    private List<String> topologyKeys = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public CSINodeDriverFluent() {
    }

    public CSINodeDriverFluent(CSINodeDriver instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CSINodeDriver instance) {
        CSINodeDriver cSINodeDriver = instance = instance != null ? instance : new CSINodeDriver();
        if (instance != null) {
            this.withAllocatable(instance.getAllocatable());
            this.withName(instance.getName());
            this.withNodeID(instance.getNodeID());
            this.withTopologyKeys(instance.getTopologyKeys());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public VolumeNodeResources buildAllocatable() {
        return this.allocatable != null ? this.allocatable.build() : null;
    }

    public A withAllocatable(VolumeNodeResources allocatable) {
        this._visitables.remove("allocatable");
        if (allocatable != null) {
            this.allocatable = new VolumeNodeResourcesBuilder(allocatable);
            this._visitables.get("allocatable").add(this.allocatable);
        } else {
            this.allocatable = null;
            this._visitables.get("allocatable").remove(this.allocatable);
        }
        return (A)this;
    }

    public boolean hasAllocatable() {
        return this.allocatable != null;
    }

    public A withNewAllocatable(Integer count) {
        return this.withAllocatable(new VolumeNodeResources(count));
    }

    public AllocatableNested<A> withNewAllocatable() {
        return new AllocatableNested(null);
    }

    public AllocatableNested<A> withNewAllocatableLike(VolumeNodeResources item) {
        return new AllocatableNested(item);
    }

    public AllocatableNested<A> editAllocatable() {
        return this.withNewAllocatableLike(Optional.ofNullable(this.buildAllocatable()).orElse(null));
    }

    public AllocatableNested<A> editOrNewAllocatable() {
        return this.withNewAllocatableLike(Optional.ofNullable(this.buildAllocatable()).orElse(new VolumeNodeResourcesBuilder().build()));
    }

    public AllocatableNested<A> editOrNewAllocatableLike(VolumeNodeResources item) {
        return this.withNewAllocatableLike(Optional.ofNullable(this.buildAllocatable()).orElse(item));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public A withNodeID(String nodeID) {
        this.nodeID = nodeID;
        return (A)this;
    }

    public boolean hasNodeID() {
        return this.nodeID != null;
    }

    public A addToTopologyKeys(int index, String item) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        this.topologyKeys.add(index, item);
        return (A)this;
    }

    public A setToTopologyKeys(int index, String item) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        this.topologyKeys.set(index, item);
        return (A)this;
    }

    public A addToTopologyKeys(String ... items) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        for (String item : items) {
            this.topologyKeys.add(item);
        }
        return (A)this;
    }

    public A addAllToTopologyKeys(Collection<String> items) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        for (String item : items) {
            this.topologyKeys.add(item);
        }
        return (A)this;
    }

    public A removeFromTopologyKeys(String ... items) {
        if (this.topologyKeys == null) {
            return (A)this;
        }
        for (String item : items) {
            this.topologyKeys.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromTopologyKeys(Collection<String> items) {
        if (this.topologyKeys == null) {
            return (A)this;
        }
        for (String item : items) {
            this.topologyKeys.remove(item);
        }
        return (A)this;
    }

    public List<String> getTopologyKeys() {
        return this.topologyKeys;
    }

    public String getTopologyKey(int index) {
        return this.topologyKeys.get(index);
    }

    public String getFirstTopologyKey() {
        return this.topologyKeys.get(0);
    }

    public String getLastTopologyKey() {
        return this.topologyKeys.get(this.topologyKeys.size() - 1);
    }

    public String getMatchingTopologyKey(Predicate<String> predicate) {
        for (String item : this.topologyKeys) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTopologyKey(Predicate<String> predicate) {
        for (String item : this.topologyKeys) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTopologyKeys(List<String> topologyKeys) {
        if (topologyKeys != null) {
            this.topologyKeys = new ArrayList<String>();
            for (String item : topologyKeys) {
                this.addToTopologyKeys(item);
            }
        } else {
            this.topologyKeys = null;
        }
        return (A)this;
    }

    public A withTopologyKeys(String ... topologyKeys) {
        if (this.topologyKeys != null) {
            this.topologyKeys.clear();
            this._visitables.remove("topologyKeys");
        }
        if (topologyKeys != null) {
            for (String item : topologyKeys) {
                this.addToTopologyKeys(item);
            }
        }
        return (A)this;
    }

    public boolean hasTopologyKeys() {
        return this.topologyKeys != null && !this.topologyKeys.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CSINodeDriverFluent that = (CSINodeDriverFluent)o;
        if (!Objects.equals(this.allocatable, that.allocatable)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.nodeID, that.nodeID)) {
            return false;
        }
        if (!Objects.equals(this.topologyKeys, that.topologyKeys)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allocatable, this.name, this.nodeID, this.topologyKeys, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocatable != null) {
            sb.append("allocatable:");
            sb.append(String.valueOf(this.allocatable) + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.nodeID != null) {
            sb.append("nodeID:");
            sb.append(this.nodeID + ",");
        }
        if (this.topologyKeys != null && !this.topologyKeys.isEmpty()) {
            sb.append("topologyKeys:");
            sb.append(String.valueOf(this.topologyKeys) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AllocatableNested<N>
    extends VolumeNodeResourcesFluent<AllocatableNested<N>>
    implements Nested<N> {
        VolumeNodeResourcesBuilder builder;

        AllocatableNested(VolumeNodeResources item) {
            this.builder = new VolumeNodeResourcesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CSINodeDriverFluent.this.withAllocatable(this.builder.build());
        }

        public N endAllocatable() {
            return this.and();
        }
    }
}

