/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1alpha3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.LocalPolicyTargetReferenceWithSectionName;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.LocalPolicyTargetReferenceWithSectionNameBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.LocalPolicyTargetReferenceWithSectionNameFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1alpha3.BackendTLSPolicySpec;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1alpha3.BackendTLSPolicyValidation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1alpha3.BackendTLSPolicyValidationBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1alpha3.BackendTLSPolicyValidationFluent;

public class BackendTLSPolicySpecFluent<A extends BackendTLSPolicySpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> options;
    private ArrayList<LocalPolicyTargetReferenceWithSectionNameBuilder> targetRefs = new ArrayList();
    private BackendTLSPolicyValidationBuilder validation;
    private Map<String, Object> additionalProperties;

    public BackendTLSPolicySpecFluent() {
    }

    public BackendTLSPolicySpecFluent(BackendTLSPolicySpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BackendTLSPolicySpec instance) {
        BackendTLSPolicySpec backendTLSPolicySpec = instance = instance != null ? instance : new BackendTLSPolicySpec();
        if (instance != null) {
            this.withOptions(instance.getOptions());
            this.withTargetRefs(instance.getTargetRefs());
            this.withValidation(instance.getValidation());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToOptions(String key, String value) {
        if (this.options == null && key != null && value != null) {
            this.options = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.options.put(key, value);
        }
        return (A)this;
    }

    public A addToOptions(Map<String, String> map) {
        if (this.options == null && map != null) {
            this.options = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.options.putAll(map);
        }
        return (A)this;
    }

    public A removeFromOptions(String key) {
        if (this.options == null) {
            return (A)this;
        }
        if (key != null && this.options != null) {
            this.options.remove(key);
        }
        return (A)this;
    }

    public A removeFromOptions(Map<String, String> map) {
        if (this.options == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.options == null) continue;
                this.options.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public <K, V> A withOptions(Map<String, String> options) {
        this.options = options == null ? null : new LinkedHashMap<String, String>(options);
        return (A)this;
    }

    public boolean hasOptions() {
        return this.options != null;
    }

    public A addToTargetRefs(int index, LocalPolicyTargetReferenceWithSectionName item) {
        if (this.targetRefs == null) {
            this.targetRefs = new ArrayList();
        }
        LocalPolicyTargetReferenceWithSectionNameBuilder builder = new LocalPolicyTargetReferenceWithSectionNameBuilder(item);
        if (index < 0 || index >= this.targetRefs.size()) {
            this._visitables.get("targetRefs").add(builder);
            this.targetRefs.add(builder);
        } else {
            this._visitables.get("targetRefs").add(builder);
            this.targetRefs.add(index, builder);
        }
        return (A)this;
    }

    public A setToTargetRefs(int index, LocalPolicyTargetReferenceWithSectionName item) {
        if (this.targetRefs == null) {
            this.targetRefs = new ArrayList();
        }
        LocalPolicyTargetReferenceWithSectionNameBuilder builder = new LocalPolicyTargetReferenceWithSectionNameBuilder(item);
        if (index < 0 || index >= this.targetRefs.size()) {
            this._visitables.get("targetRefs").add(builder);
            this.targetRefs.add(builder);
        } else {
            this._visitables.get("targetRefs").add(builder);
            this.targetRefs.set(index, builder);
        }
        return (A)this;
    }

    public A addToTargetRefs(LocalPolicyTargetReferenceWithSectionName ... items) {
        if (this.targetRefs == null) {
            this.targetRefs = new ArrayList();
        }
        for (LocalPolicyTargetReferenceWithSectionName item : items) {
            LocalPolicyTargetReferenceWithSectionNameBuilder builder = new LocalPolicyTargetReferenceWithSectionNameBuilder(item);
            this._visitables.get("targetRefs").add(builder);
            this.targetRefs.add(builder);
        }
        return (A)this;
    }

    public A addAllToTargetRefs(Collection<LocalPolicyTargetReferenceWithSectionName> items) {
        if (this.targetRefs == null) {
            this.targetRefs = new ArrayList();
        }
        for (LocalPolicyTargetReferenceWithSectionName item : items) {
            LocalPolicyTargetReferenceWithSectionNameBuilder builder = new LocalPolicyTargetReferenceWithSectionNameBuilder(item);
            this._visitables.get("targetRefs").add(builder);
            this.targetRefs.add(builder);
        }
        return (A)this;
    }

    public A removeFromTargetRefs(LocalPolicyTargetReferenceWithSectionName ... items) {
        if (this.targetRefs == null) {
            return (A)this;
        }
        for (LocalPolicyTargetReferenceWithSectionName item : items) {
            LocalPolicyTargetReferenceWithSectionNameBuilder builder = new LocalPolicyTargetReferenceWithSectionNameBuilder(item);
            this._visitables.get("targetRefs").remove(builder);
            this.targetRefs.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTargetRefs(Collection<LocalPolicyTargetReferenceWithSectionName> items) {
        if (this.targetRefs == null) {
            return (A)this;
        }
        for (LocalPolicyTargetReferenceWithSectionName item : items) {
            LocalPolicyTargetReferenceWithSectionNameBuilder builder = new LocalPolicyTargetReferenceWithSectionNameBuilder(item);
            this._visitables.get("targetRefs").remove(builder);
            this.targetRefs.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTargetRefs(Predicate<LocalPolicyTargetReferenceWithSectionNameBuilder> predicate) {
        if (this.targetRefs == null) {
            return (A)this;
        }
        Iterator<LocalPolicyTargetReferenceWithSectionNameBuilder> each = this.targetRefs.iterator();
        Object visitables = this._visitables.get("targetRefs");
        while (each.hasNext()) {
            LocalPolicyTargetReferenceWithSectionNameBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<LocalPolicyTargetReferenceWithSectionName> buildTargetRefs() {
        return this.targetRefs != null ? BackendTLSPolicySpecFluent.build(this.targetRefs) : null;
    }

    public LocalPolicyTargetReferenceWithSectionName buildTargetRef(int index) {
        return this.targetRefs.get(index).build();
    }

    public LocalPolicyTargetReferenceWithSectionName buildFirstTargetRef() {
        return this.targetRefs.get(0).build();
    }

    public LocalPolicyTargetReferenceWithSectionName buildLastTargetRef() {
        return this.targetRefs.get(this.targetRefs.size() - 1).build();
    }

    public LocalPolicyTargetReferenceWithSectionName buildMatchingTargetRef(Predicate<LocalPolicyTargetReferenceWithSectionNameBuilder> predicate) {
        for (LocalPolicyTargetReferenceWithSectionNameBuilder item : this.targetRefs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTargetRef(Predicate<LocalPolicyTargetReferenceWithSectionNameBuilder> predicate) {
        for (LocalPolicyTargetReferenceWithSectionNameBuilder item : this.targetRefs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTargetRefs(List<LocalPolicyTargetReferenceWithSectionName> targetRefs) {
        if (this.targetRefs != null) {
            this._visitables.get("targetRefs").clear();
        }
        if (targetRefs != null) {
            this.targetRefs = new ArrayList();
            for (LocalPolicyTargetReferenceWithSectionName item : targetRefs) {
                this.addToTargetRefs(item);
            }
        } else {
            this.targetRefs = null;
        }
        return (A)this;
    }

    public A withTargetRefs(LocalPolicyTargetReferenceWithSectionName ... targetRefs) {
        if (this.targetRefs != null) {
            this.targetRefs.clear();
            this._visitables.remove("targetRefs");
        }
        if (targetRefs != null) {
            for (LocalPolicyTargetReferenceWithSectionName item : targetRefs) {
                this.addToTargetRefs(item);
            }
        }
        return (A)this;
    }

    public boolean hasTargetRefs() {
        return this.targetRefs != null && !this.targetRefs.isEmpty();
    }

    public A addNewTargetRef(String group, String kind, String name, String sectionName) {
        return this.addToTargetRefs(new LocalPolicyTargetReferenceWithSectionName(group, kind, name, sectionName));
    }

    public TargetRefsNested<A> addNewTargetRef() {
        return new TargetRefsNested(-1, null);
    }

    public TargetRefsNested<A> addNewTargetRefLike(LocalPolicyTargetReferenceWithSectionName item) {
        return new TargetRefsNested(-1, item);
    }

    public TargetRefsNested<A> setNewTargetRefLike(int index, LocalPolicyTargetReferenceWithSectionName item) {
        return new TargetRefsNested(index, item);
    }

    public TargetRefsNested<A> editTargetRef(int index) {
        if (this.targetRefs.size() <= index) {
            throw new RuntimeException("Can't edit targetRefs. Index exceeds size.");
        }
        return this.setNewTargetRefLike(index, this.buildTargetRef(index));
    }

    public TargetRefsNested<A> editFirstTargetRef() {
        if (this.targetRefs.size() == 0) {
            throw new RuntimeException("Can't edit first targetRefs. The list is empty.");
        }
        return this.setNewTargetRefLike(0, this.buildTargetRef(0));
    }

    public TargetRefsNested<A> editLastTargetRef() {
        int index = this.targetRefs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last targetRefs. The list is empty.");
        }
        return this.setNewTargetRefLike(index, this.buildTargetRef(index));
    }

    public TargetRefsNested<A> editMatchingTargetRef(Predicate<LocalPolicyTargetReferenceWithSectionNameBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.targetRefs.size(); ++i) {
            if (!predicate.test(this.targetRefs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching targetRefs. No match found.");
        }
        return this.setNewTargetRefLike(index, this.buildTargetRef(index));
    }

    public BackendTLSPolicyValidation buildValidation() {
        return this.validation != null ? this.validation.build() : null;
    }

    public A withValidation(BackendTLSPolicyValidation validation) {
        this._visitables.remove("validation");
        if (validation != null) {
            this.validation = new BackendTLSPolicyValidationBuilder(validation);
            this._visitables.get("validation").add(this.validation);
        } else {
            this.validation = null;
            this._visitables.get("validation").remove(this.validation);
        }
        return (A)this;
    }

    public boolean hasValidation() {
        return this.validation != null;
    }

    public ValidationNested<A> withNewValidation() {
        return new ValidationNested(null);
    }

    public ValidationNested<A> withNewValidationLike(BackendTLSPolicyValidation item) {
        return new ValidationNested(item);
    }

    public ValidationNested<A> editValidation() {
        return this.withNewValidationLike(Optional.ofNullable(this.buildValidation()).orElse(null));
    }

    public ValidationNested<A> editOrNewValidation() {
        return this.withNewValidationLike(Optional.ofNullable(this.buildValidation()).orElse(new BackendTLSPolicyValidationBuilder().build()));
    }

    public ValidationNested<A> editOrNewValidationLike(BackendTLSPolicyValidation item) {
        return this.withNewValidationLike(Optional.ofNullable(this.buildValidation()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BackendTLSPolicySpecFluent that = (BackendTLSPolicySpecFluent)o;
        if (!Objects.equals(this.options, that.options)) {
            return false;
        }
        if (!Objects.equals(this.targetRefs, that.targetRefs)) {
            return false;
        }
        if (!Objects.equals(this.validation, that.validation)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.options, this.targetRefs, this.validation, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.options != null && !this.options.isEmpty()) {
            sb.append("options:");
            sb.append(String.valueOf(this.options) + ",");
        }
        if (this.targetRefs != null && !this.targetRefs.isEmpty()) {
            sb.append("targetRefs:");
            sb.append(String.valueOf(this.targetRefs) + ",");
        }
        if (this.validation != null) {
            sb.append("validation:");
            sb.append(String.valueOf(this.validation) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ValidationNested<N>
    extends BackendTLSPolicyValidationFluent<ValidationNested<N>>
    implements Nested<N> {
        BackendTLSPolicyValidationBuilder builder;

        ValidationNested(BackendTLSPolicyValidation item) {
            this.builder = new BackendTLSPolicyValidationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BackendTLSPolicySpecFluent.this.withValidation(this.builder.build());
        }

        public N endValidation() {
            return this.and();
        }
    }

    public class TargetRefsNested<N>
    extends LocalPolicyTargetReferenceWithSectionNameFluent<TargetRefsNested<N>>
    implements Nested<N> {
        LocalPolicyTargetReferenceWithSectionNameBuilder builder;
        int index;

        TargetRefsNested(int index, LocalPolicyTargetReferenceWithSectionName item) {
            this.index = index;
            this.builder = new LocalPolicyTargetReferenceWithSectionNameBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BackendTLSPolicySpecFluent.this.setToTargetRefs(this.index, this.builder.build());
        }

        public N endTargetRef() {
            return this.and();
        }
    }
}

