/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ConfigMapVolumeSource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KeyToPath;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KeyToPathBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KeyToPathFluent;

public class ConfigMapVolumeSourceFluent<A extends ConfigMapVolumeSourceFluent<A>>
extends BaseFluent<A> {
    private Integer defaultMode;
    private ArrayList<KeyToPathBuilder> items = new ArrayList();
    private String name;
    private Boolean optional;
    private Map<String, Object> additionalProperties;

    public ConfigMapVolumeSourceFluent() {
    }

    public ConfigMapVolumeSourceFluent(ConfigMapVolumeSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ConfigMapVolumeSource instance) {
        ConfigMapVolumeSource configMapVolumeSource = instance = instance != null ? instance : new ConfigMapVolumeSource();
        if (instance != null) {
            this.withDefaultMode(instance.getDefaultMode());
            this.withItems(instance.getItems());
            this.withName(instance.getName());
            this.withOptional(instance.getOptional());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    public A withDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return (A)this;
    }

    public boolean hasDefaultMode() {
        return this.defaultMode != null;
    }

    public A addToItems(int index, KeyToPath item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        KeyToPathBuilder builder = new KeyToPathBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get("items").add(builder);
            this.items.add(index, builder);
        }
        return (A)this;
    }

    public A setToItems(int index, KeyToPath item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        KeyToPathBuilder builder = new KeyToPathBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get("items").add(builder);
            this.items.set(index, builder);
        }
        return (A)this;
    }

    public A addToItems(KeyToPath ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    public A addAllToItems(Collection<KeyToPath> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    public A removeFromItems(KeyToPath ... items) {
        if (this.items == null) {
            return (A)this;
        }
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.get("items").remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromItems(Collection<KeyToPath> items) {
        if (this.items == null) {
            return (A)this;
        }
        for (KeyToPath item : items) {
            KeyToPathBuilder builder = new KeyToPathBuilder(item);
            this._visitables.get("items").remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromItems(Predicate<KeyToPathBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<KeyToPathBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            KeyToPathBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<KeyToPath> buildItems() {
        return this.items != null ? ConfigMapVolumeSourceFluent.build(this.items) : null;
    }

    public KeyToPath buildItem(int index) {
        return this.items.get(index).build();
    }

    public KeyToPath buildFirstItem() {
        return this.items.get(0).build();
    }

    public KeyToPath buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    public KeyToPath buildMatchingItem(Predicate<KeyToPathBuilder> predicate) {
        for (KeyToPathBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingItem(Predicate<KeyToPathBuilder> predicate) {
        for (KeyToPathBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withItems(List<KeyToPath> items) {
        if (this.items != null) {
            this._visitables.get("items").clear();
        }
        if (items != null) {
            this.items = new ArrayList();
            for (KeyToPath item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    public A withItems(KeyToPath ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove("items");
        }
        if (items != null) {
            for (KeyToPath item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public A addNewItem(String key, Integer mode, String path) {
        return this.addToItems(new KeyToPath(key, mode, path));
    }

    public ItemsNested<A> addNewItem() {
        return new ItemsNested(-1, null);
    }

    public ItemsNested<A> addNewItemLike(KeyToPath item) {
        return new ItemsNested(-1, item);
    }

    public ItemsNested<A> setNewItemLike(int index, KeyToPath item) {
        return new ItemsNested(index, item);
    }

    public ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    public ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editMatchingItem(Predicate<KeyToPathBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public A withOptional(Boolean optional) {
        this.optional = optional;
        return (A)this;
    }

    public boolean hasOptional() {
        return this.optional != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigMapVolumeSourceFluent that = (ConfigMapVolumeSourceFluent)o;
        if (!Objects.equals(this.defaultMode, that.defaultMode)) {
            return false;
        }
        if (!Objects.equals(this.items, that.items)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.optional, that.optional)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.defaultMode, this.items, this.name, this.optional, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.defaultMode != null) {
            sb.append("defaultMode:");
            sb.append(this.defaultMode + ",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(String.valueOf(this.items) + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.optional != null) {
            sb.append("optional:");
            sb.append(this.optional + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withOptional() {
        return this.withOptional(true);
    }

    public class ItemsNested<N>
    extends KeyToPathFluent<ItemsNested<N>>
    implements Nested<N> {
        KeyToPathBuilder builder;
        int index;

        ItemsNested(int index, KeyToPath item) {
            this.index = index;
            this.builder = new KeyToPathBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConfigMapVolumeSourceFluent.this.setToItems(this.index, this.builder.build());
        }

        public N endItem() {
            return this.and();
        }
    }
}

