/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.HttpHeaders;

public class StandardHttpHeaders
implements HttpHeaders {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String EXPECT = "Expect";
    public static final String EXPECT_CONTINUE = "100-continue";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    private final Map<String, List<String>> headers;

    public StandardHttpHeaders() {
        this(new LinkedHashMap<String, List<String>>());
    }

    public StandardHttpHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    @Override
    public List<String> headers(String key) {
        return Collections.unmodifiableList(this.headers.getOrDefault(key, Collections.emptyList()));
    }

    @Override
    public Map<String, List<String>> headers() {
        return Collections.unmodifiableMap(this.headers);
    }
}

