/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.core.v1;

import java.io.IOException;
import java.net.URL;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ServiceAccount;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ServiceAccountList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.authentication.TokenRequest;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.Client;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.KubernetesClientException;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.ServiceAccountResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.HttpRequest;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.URLUtils;

public class ServiceAccountOperationsImpl
extends HasMetadataOperation<ServiceAccount, ServiceAccountList, ServiceAccountResource>
implements ServiceAccountResource {
    public ServiceAccountOperationsImpl(Client client) {
        this(HasMetadataOperationsImpl.defaultContext(client));
    }

    private ServiceAccountOperationsImpl(OperationContext context) {
        super(context.withPlural("serviceaccounts"), ServiceAccount.class, ServiceAccountList.class);
    }

    @Override
    public ServiceAccountOperationsImpl newInstance(OperationContext context) {
        return new ServiceAccountOperationsImpl(context);
    }

    @Override
    public TokenRequest tokenRequest(TokenRequest tokenRequest) {
        return this.handleTokenRequest(tokenRequest);
    }

    private TokenRequest handleTokenRequest(TokenRequest tokenRequest) {
        try {
            URL requestUrl = new URL(URLUtils.join(this.getResourceUrl().toString(), "token"));
            HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().post("application/json", this.getKubernetesSerialization().asJson(tokenRequest)).url(requestUrl);
            return this.handleResponse(requestBuilder, TokenRequest.class);
        }
        catch (IOException exception) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("token request"), (Throwable)exception);
        }
    }
}

