/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequest;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionResponse;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionResponseBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionResponseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionReview;

public class ConversionReviewFluent<A extends ConversionReviewFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private ConversionRequestBuilder request;
    private ConversionResponseBuilder response;
    private Map<String, Object> additionalProperties;

    public ConversionReviewFluent() {
    }

    public ConversionReviewFluent(ConversionReview instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ConversionReview instance) {
        ConversionReview conversionReview = instance = instance != null ? instance : new ConversionReview();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withRequest(instance.getRequest());
            this.withResponse(instance.getResponse());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ConversionRequest buildRequest() {
        return this.request != null ? this.request.build() : null;
    }

    public A withRequest(ConversionRequest request) {
        this._visitables.remove("request");
        if (request != null) {
            this.request = new ConversionRequestBuilder(request);
            this._visitables.get("request").add(this.request);
        } else {
            this.request = null;
            this._visitables.get("request").remove(this.request);
        }
        return (A)this;
    }

    public boolean hasRequest() {
        return this.request != null;
    }

    public RequestNested<A> withNewRequest() {
        return new RequestNested(null);
    }

    public RequestNested<A> withNewRequestLike(ConversionRequest item) {
        return new RequestNested(item);
    }

    public RequestNested<A> editRequest() {
        return this.withNewRequestLike(Optional.ofNullable(this.buildRequest()).orElse(null));
    }

    public RequestNested<A> editOrNewRequest() {
        return this.withNewRequestLike(Optional.ofNullable(this.buildRequest()).orElse(new ConversionRequestBuilder().build()));
    }

    public RequestNested<A> editOrNewRequestLike(ConversionRequest item) {
        return this.withNewRequestLike(Optional.ofNullable(this.buildRequest()).orElse(item));
    }

    public ConversionResponse buildResponse() {
        return this.response != null ? this.response.build() : null;
    }

    public A withResponse(ConversionResponse response) {
        this._visitables.remove("response");
        if (response != null) {
            this.response = new ConversionResponseBuilder(response);
            this._visitables.get("response").add(this.response);
        } else {
            this.response = null;
            this._visitables.get("response").remove(this.response);
        }
        return (A)this;
    }

    public boolean hasResponse() {
        return this.response != null;
    }

    public ResponseNested<A> withNewResponse() {
        return new ResponseNested(null);
    }

    public ResponseNested<A> withNewResponseLike(ConversionResponse item) {
        return new ResponseNested(item);
    }

    public ResponseNested<A> editResponse() {
        return this.withNewResponseLike(Optional.ofNullable(this.buildResponse()).orElse(null));
    }

    public ResponseNested<A> editOrNewResponse() {
        return this.withNewResponseLike(Optional.ofNullable(this.buildResponse()).orElse(new ConversionResponseBuilder().build()));
    }

    public ResponseNested<A> editOrNewResponseLike(ConversionResponse item) {
        return this.withNewResponseLike(Optional.ofNullable(this.buildResponse()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConversionReviewFluent that = (ConversionReviewFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.request, that.request)) {
            return false;
        }
        if (!Objects.equals(this.response, that.response)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.request, this.response, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.request != null) {
            sb.append("request:");
            sb.append(this.request + ",");
        }
        if (this.response != null) {
            sb.append("response:");
            sb.append(this.response + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResponseNested<N>
    extends ConversionResponseFluent<ResponseNested<N>>
    implements Nested<N> {
        ConversionResponseBuilder builder;

        ResponseNested(ConversionResponse item) {
            this.builder = new ConversionResponseBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConversionReviewFluent.this.withResponse(this.builder.build());
        }

        public N endResponse() {
            return this.and();
        }
    }

    public class RequestNested<N>
    extends ConversionRequestFluent<RequestNested<N>>
    implements Nested<N> {
        ConversionRequestBuilder builder;

        RequestNested(ConversionRequest item) {
            this.builder = new ConversionRequestBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConversionReviewFluent.this.withRequest(this.builder.build());
        }

        public N endRequest() {
            return this.and();
        }
    }
}

