/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.decorators;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.AbstractKubernetesParameters;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesSecretEnvVar;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Container;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EnvVar;
import org.apache.flink.util.Preconditions;

public class EnvSecretsDecorator
extends AbstractKubernetesStepDecorator {
    private final AbstractKubernetesParameters kubernetesComponentConf;

    public EnvSecretsDecorator(AbstractKubernetesParameters kubernetesComponentConf) {
        this.kubernetesComponentConf = (AbstractKubernetesParameters)Preconditions.checkNotNull((Object)kubernetesComponentConf);
    }

    @Override
    public FlinkPod decorateFlinkPod(FlinkPod flinkPod) {
        Container basicMainContainer = ((ContainerBuilder)new ContainerBuilder(flinkPod.getMainContainer()).addAllToEnv(this.getSecretEnvs())).build();
        return new FlinkPod.Builder(flinkPod).withMainContainer(basicMainContainer).build();
    }

    private List<EnvVar> getSecretEnvs() {
        return this.kubernetesComponentConf.getEnvironmentsFromSecrets().stream().map(e -> (EnvVar)KubernetesSecretEnvVar.fromMap(e).getInternalResource()).collect(Collectors.toList());
    }
}

