/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.model.jackson;

import java.util.stream.Collectors;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.BeanDescription;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.SerializationConfig;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.model.jackson.BeanPropertyWriterDelegate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.model.jackson.SettableBeanPropertyDelegate;

public class UnmatchedFieldTypeModule
extends SimpleModule {
    private boolean logWarnings;
    private boolean restrictToTemplates;
    private static final ThreadLocal<Boolean> IN_TEMPLATE = ThreadLocal.withInitial(() -> false);

    public UnmatchedFieldTypeModule() {
        this(true, true);
    }

    public UnmatchedFieldTypeModule(boolean logWarnings, boolean restrictToTemplates) {
        this.logWarnings = logWarnings;
        this.restrictToTemplates = restrictToTemplates;
        this.setDeserializerModifier(new BeanDeserializerModifier(){

            @Override
            public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
                builder.getProperties().forEachRemaining(p -> builder.addOrReplaceProperty(new SettableBeanPropertyDelegate((SettableBeanProperty)p, builder.getAnySetter(), UnmatchedFieldTypeModule.this::useAnySetter){}, true));
                return builder;
            }
        });
        this.setSerializerModifier(new BeanSerializerModifier(){

            @Override
            public BeanSerializerBuilder updateBuilder(SerializationConfig config, BeanDescription beanDesc, BeanSerializerBuilder builder) {
                builder.setProperties(builder.getProperties().stream().map(p -> new BeanPropertyWriterDelegate((BeanPropertyWriter)p, builder.getBeanDescription().findAnyGetter(), UnmatchedFieldTypeModule.this::isLogWarnings)).collect(Collectors.toList()));
                return builder;
            }
        });
    }

    boolean isLogWarnings() {
        return this.logWarnings;
    }

    public void setLogWarnings(boolean logWarnings) {
        this.logWarnings = logWarnings;
    }

    boolean isRestrictToTemplates() {
        return this.restrictToTemplates;
    }

    boolean useAnySetter() {
        return !this.restrictToTemplates || UnmatchedFieldTypeModule.isInTemplate();
    }

    public void setRestrictToTemplates(boolean restrictToTemplates) {
        this.restrictToTemplates = restrictToTemplates;
    }

    public static boolean isInTemplate() {
        return Boolean.TRUE.equals(IN_TEMPLATE.get());
    }

    public static void setInTemplate() {
        IN_TEMPLATE.set(true);
    }

    public static void removeInTemplate() {
        IN_TEMPLATE.remove();
    }
}

