/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1.HTTPBackendRef;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1.HTTPRouteFilter;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1.HTTPRouteFilterBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1.HTTPRouteFilterFluent;

public class HTTPBackendRefFluent<A extends HTTPBackendRefFluent<A>>
extends BaseFluent<A> {
    private ArrayList<HTTPRouteFilterBuilder> filters = new ArrayList();
    private String group;
    private String kind;
    private String name;
    private String namespace;
    private Integer port;
    private Integer weight;
    private Map<String, Object> additionalProperties;

    public HTTPBackendRefFluent() {
    }

    public HTTPBackendRefFluent(HTTPBackendRef instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HTTPBackendRef instance) {
        HTTPBackendRef hTTPBackendRef = instance = instance != null ? instance : new HTTPBackendRef();
        if (instance != null) {
            this.withFilters(instance.getFilters());
            this.withGroup(instance.getGroup());
            this.withKind(instance.getKind());
            this.withName(instance.getName());
            this.withNamespace(instance.getNamespace());
            this.withPort(instance.getPort());
            this.withWeight(instance.getWeight());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToFilters(int index, HTTPRouteFilter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get("filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get("filters").add(index, builder);
            this.filters.add(index, builder);
        }
        return (A)this;
    }

    public A setToFilters(int index, HTTPRouteFilter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get("filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get("filters").set(index, builder);
            this.filters.set(index, builder);
        }
        return (A)this;
    }

    public A addToFilters(HTTPRouteFilter ... items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (HTTPRouteFilter item : items) {
            HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
            this._visitables.get("filters").add(builder);
            this.filters.add(builder);
        }
        return (A)this;
    }

    public A addAllToFilters(Collection<HTTPRouteFilter> items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (HTTPRouteFilter item : items) {
            HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
            this._visitables.get("filters").add(builder);
            this.filters.add(builder);
        }
        return (A)this;
    }

    public A removeFromFilters(HTTPRouteFilter ... items) {
        if (this.filters == null) {
            return (A)this;
        }
        for (HTTPRouteFilter item : items) {
            HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
            this._visitables.get("filters").remove(builder);
            this.filters.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromFilters(Collection<HTTPRouteFilter> items) {
        if (this.filters == null) {
            return (A)this;
        }
        for (HTTPRouteFilter item : items) {
            HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
            this._visitables.get("filters").remove(builder);
            this.filters.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromFilters(Predicate<HTTPRouteFilterBuilder> predicate) {
        if (this.filters == null) {
            return (A)this;
        }
        Iterator<HTTPRouteFilterBuilder> each = this.filters.iterator();
        Object visitables = this._visitables.get("filters");
        while (each.hasNext()) {
            HTTPRouteFilterBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<HTTPRouteFilter> buildFilters() {
        return this.filters != null ? HTTPBackendRefFluent.build(this.filters) : null;
    }

    public HTTPRouteFilter buildFilter(int index) {
        return this.filters.get(index).build();
    }

    public HTTPRouteFilter buildFirstFilter() {
        return this.filters.get(0).build();
    }

    public HTTPRouteFilter buildLastFilter() {
        return this.filters.get(this.filters.size() - 1).build();
    }

    public HTTPRouteFilter buildMatchingFilter(Predicate<HTTPRouteFilterBuilder> predicate) {
        for (HTTPRouteFilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingFilter(Predicate<HTTPRouteFilterBuilder> predicate) {
        for (HTTPRouteFilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFilters(List<HTTPRouteFilter> filters) {
        if (this.filters != null) {
            this._visitables.get("filters").clear();
        }
        if (filters != null) {
            this.filters = new ArrayList();
            for (HTTPRouteFilter item : filters) {
                this.addToFilters(item);
            }
        } else {
            this.filters = null;
        }
        return (A)this;
    }

    public A withFilters(HTTPRouteFilter ... filters) {
        if (this.filters != null) {
            this.filters.clear();
            this._visitables.remove("filters");
        }
        if (filters != null) {
            for (HTTPRouteFilter item : filters) {
                this.addToFilters(item);
            }
        }
        return (A)this;
    }

    public boolean hasFilters() {
        return this.filters != null && !this.filters.isEmpty();
    }

    public FiltersNested<A> addNewFilter() {
        return new FiltersNested(-1, null);
    }

    public FiltersNested<A> addNewFilterLike(HTTPRouteFilter item) {
        return new FiltersNested(-1, item);
    }

    public FiltersNested<A> setNewFilterLike(int index, HTTPRouteFilter item) {
        return new FiltersNested(index, item);
    }

    public FiltersNested<A> editFilter(int index) {
        if (this.filters.size() <= index) {
            throw new RuntimeException("Can't edit filters. Index exceeds size.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public FiltersNested<A> editFirstFilter() {
        if (this.filters.size() == 0) {
            throw new RuntimeException("Can't edit first filters. The list is empty.");
        }
        return this.setNewFilterLike(0, this.buildFilter(0));
    }

    public FiltersNested<A> editLastFilter() {
        int index = this.filters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last filters. The list is empty.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public FiltersNested<A> editMatchingFilter(Predicate<HTTPRouteFilterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.filters.size(); ++i) {
            if (!predicate.test(this.filters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching filters. No match found.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public String getGroup() {
        return this.group;
    }

    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public Integer getPort() {
        return this.port;
    }

    public A withPort(Integer port) {
        this.port = port;
        return (A)this;
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public A withWeight(Integer weight) {
        this.weight = weight;
        return (A)this;
    }

    public boolean hasWeight() {
        return this.weight != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPBackendRefFluent that = (HTTPBackendRefFluent)o;
        if (!Objects.equals(this.filters, that.filters)) {
            return false;
        }
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.weight, that.weight)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.filters, this.group, this.kind, this.name, this.namespace, this.port, this.weight, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters != null && !this.filters.isEmpty()) {
            sb.append("filters:");
            sb.append(this.filters + ",");
        }
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.weight != null) {
            sb.append("weight:");
            sb.append(this.weight + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class FiltersNested<N>
    extends HTTPRouteFilterFluent<FiltersNested<N>>
    implements Nested<N> {
        HTTPRouteFilterBuilder builder;
        int index;

        FiltersNested(int index, HTTPRouteFilter item) {
            this.index = index;
            this.builder = new HTTPRouteFilterBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HTTPBackendRefFluent.this.setToFilters(this.index, this.builder.build());
        }

        public N endFilter() {
            return this.and();
        }
    }
}

