/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EventSeries;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.MicroTime;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.MicroTimeBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.MicroTimeFluent;

public class EventSeriesFluent<A extends EventSeriesFluent<A>>
extends BaseFluent<A> {
    private Integer count;
    private MicroTimeBuilder lastObservedTime;
    private Map<String, Object> additionalProperties;

    public EventSeriesFluent() {
    }

    public EventSeriesFluent(EventSeries instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(EventSeries instance) {
        EventSeries eventSeries = instance = instance != null ? instance : new EventSeries();
        if (instance != null) {
            this.withCount(instance.getCount());
            this.withLastObservedTime(instance.getLastObservedTime());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getCount() {
        return this.count;
    }

    public A withCount(Integer count) {
        this.count = count;
        return (A)this;
    }

    public boolean hasCount() {
        return this.count != null;
    }

    public MicroTime buildLastObservedTime() {
        return this.lastObservedTime != null ? this.lastObservedTime.build() : null;
    }

    public A withLastObservedTime(MicroTime lastObservedTime) {
        this._visitables.remove("lastObservedTime");
        if (lastObservedTime != null) {
            this.lastObservedTime = new MicroTimeBuilder(lastObservedTime);
            this._visitables.get("lastObservedTime").add(this.lastObservedTime);
        } else {
            this.lastObservedTime = null;
            this._visitables.get("lastObservedTime").remove(this.lastObservedTime);
        }
        return (A)this;
    }

    public boolean hasLastObservedTime() {
        return this.lastObservedTime != null;
    }

    public A withNewLastObservedTime(String time) {
        return this.withLastObservedTime(new MicroTime(time));
    }

    public LastObservedTimeNested<A> withNewLastObservedTime() {
        return new LastObservedTimeNested(null);
    }

    public LastObservedTimeNested<A> withNewLastObservedTimeLike(MicroTime item) {
        return new LastObservedTimeNested(item);
    }

    public LastObservedTimeNested<A> editLastObservedTime() {
        return this.withNewLastObservedTimeLike(Optional.ofNullable(this.buildLastObservedTime()).orElse(null));
    }

    public LastObservedTimeNested<A> editOrNewLastObservedTime() {
        return this.withNewLastObservedTimeLike(Optional.ofNullable(this.buildLastObservedTime()).orElse(new MicroTimeBuilder().build()));
    }

    public LastObservedTimeNested<A> editOrNewLastObservedTimeLike(MicroTime item) {
        return this.withNewLastObservedTimeLike(Optional.ofNullable(this.buildLastObservedTime()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventSeriesFluent that = (EventSeriesFluent)o;
        if (!Objects.equals(this.count, that.count)) {
            return false;
        }
        if (!Objects.equals(this.lastObservedTime, that.lastObservedTime)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.count, this.lastObservedTime, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.count != null) {
            sb.append("count:");
            sb.append(this.count + ",");
        }
        if (this.lastObservedTime != null) {
            sb.append("lastObservedTime:");
            sb.append(this.lastObservedTime + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class LastObservedTimeNested<N>
    extends MicroTimeFluent<LastObservedTimeNested<N>>
    implements Nested<N> {
        MicroTimeBuilder builder;

        LastObservedTimeNested(MicroTime item) {
            this.builder = new MicroTimeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EventSeriesFluent.this.withLastObservedTime(this.builder.build());
        }

        public N endLastObservedTime() {
            return this.and();
        }
    }
}

