/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ConfigMapEnvSource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ConfigMapEnvSourceBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ConfigMapEnvSourceFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EnvFromSource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.SecretEnvSource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.SecretEnvSourceBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.SecretEnvSourceFluent;

public class EnvFromSourceFluent<A extends EnvFromSourceFluent<A>>
extends BaseFluent<A> {
    private ConfigMapEnvSourceBuilder configMapRef;
    private String prefix;
    private SecretEnvSourceBuilder secretRef;
    private Map<String, Object> additionalProperties;

    public EnvFromSourceFluent() {
    }

    public EnvFromSourceFluent(EnvFromSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(EnvFromSource instance) {
        EnvFromSource envFromSource = instance = instance != null ? instance : new EnvFromSource();
        if (instance != null) {
            this.withConfigMapRef(instance.getConfigMapRef());
            this.withPrefix(instance.getPrefix());
            this.withSecretRef(instance.getSecretRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConfigMapEnvSource buildConfigMapRef() {
        return this.configMapRef != null ? this.configMapRef.build() : null;
    }

    public A withConfigMapRef(ConfigMapEnvSource configMapRef) {
        this._visitables.remove("configMapRef");
        if (configMapRef != null) {
            this.configMapRef = new ConfigMapEnvSourceBuilder(configMapRef);
            this._visitables.get("configMapRef").add(this.configMapRef);
        } else {
            this.configMapRef = null;
            this._visitables.get("configMapRef").remove(this.configMapRef);
        }
        return (A)this;
    }

    public boolean hasConfigMapRef() {
        return this.configMapRef != null;
    }

    public A withNewConfigMapRef(String name, Boolean optional) {
        return this.withConfigMapRef(new ConfigMapEnvSource(name, optional));
    }

    public ConfigMapRefNested<A> withNewConfigMapRef() {
        return new ConfigMapRefNested(null);
    }

    public ConfigMapRefNested<A> withNewConfigMapRefLike(ConfigMapEnvSource item) {
        return new ConfigMapRefNested(item);
    }

    public ConfigMapRefNested<A> editConfigMapRef() {
        return this.withNewConfigMapRefLike(Optional.ofNullable(this.buildConfigMapRef()).orElse(null));
    }

    public ConfigMapRefNested<A> editOrNewConfigMapRef() {
        return this.withNewConfigMapRefLike(Optional.ofNullable(this.buildConfigMapRef()).orElse(new ConfigMapEnvSourceBuilder().build()));
    }

    public ConfigMapRefNested<A> editOrNewConfigMapRefLike(ConfigMapEnvSource item) {
        return this.withNewConfigMapRefLike(Optional.ofNullable(this.buildConfigMapRef()).orElse(item));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public A withPrefix(String prefix) {
        this.prefix = prefix;
        return (A)this;
    }

    public boolean hasPrefix() {
        return this.prefix != null;
    }

    public SecretEnvSource buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    public A withSecretRef(SecretEnvSource secretRef) {
        this._visitables.remove("secretRef");
        if (secretRef != null) {
            this.secretRef = new SecretEnvSourceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get("secretRef").remove(this.secretRef);
        }
        return (A)this;
    }

    public boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public A withNewSecretRef(String name, Boolean optional) {
        return this.withSecretRef(new SecretEnvSource(name, optional));
    }

    public SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNested(null);
    }

    public SecretRefNested<A> withNewSecretRefLike(SecretEnvSource item) {
        return new SecretRefNested(item);
    }

    public SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(null));
    }

    public SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(new SecretEnvSourceBuilder().build()));
    }

    public SecretRefNested<A> editOrNewSecretRefLike(SecretEnvSource item) {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnvFromSourceFluent that = (EnvFromSourceFluent)o;
        if (!Objects.equals(this.configMapRef, that.configMapRef)) {
            return false;
        }
        if (!Objects.equals(this.prefix, that.prefix)) {
            return false;
        }
        if (!Objects.equals(this.secretRef, that.secretRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.configMapRef, this.prefix, this.secretRef, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configMapRef != null) {
            sb.append("configMapRef:");
            sb.append(this.configMapRef + ",");
        }
        if (this.prefix != null) {
            sb.append("prefix:");
            sb.append(this.prefix + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SecretRefNested<N>
    extends SecretEnvSourceFluent<SecretRefNested<N>>
    implements Nested<N> {
        SecretEnvSourceBuilder builder;

        SecretRefNested(SecretEnvSource item) {
            this.builder = new SecretEnvSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EnvFromSourceFluent.this.withSecretRef(this.builder.build());
        }

        public N endSecretRef() {
            return this.and();
        }
    }

    public class ConfigMapRefNested<N>
    extends ConfigMapEnvSourceFluent<ConfigMapRefNested<N>>
    implements Nested<N> {
        ConfigMapEnvSourceBuilder builder;

        ConfigMapRefNested(ConfigMapEnvSource item) {
            this.builder = new ConfigMapEnvSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EnvFromSourceFluent.this.withConfigMapRef(this.builder.build());
        }

        public N endConfigMapRef() {
            return this.and();
        }
    }
}

