/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.AuditAnnotation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.AuditAnnotationBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.AuditAnnotationFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.MatchCondition;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.MatchConditionBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.MatchConditionFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.MatchResources;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.MatchResourcesBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.MatchResourcesFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.ParamKind;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.ParamKindBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.ParamKindFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.ValidatingAdmissionPolicySpec;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.Validation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.ValidationBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.ValidationFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.Variable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.VariableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.admissionregistration.v1.VariableFluent;

public class ValidatingAdmissionPolicySpecFluent<A extends ValidatingAdmissionPolicySpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<AuditAnnotationBuilder> auditAnnotations = new ArrayList();
    private String failurePolicy;
    private ArrayList<MatchConditionBuilder> matchConditions = new ArrayList();
    private MatchResourcesBuilder matchConstraints;
    private ParamKindBuilder paramKind;
    private ArrayList<ValidationBuilder> validations = new ArrayList();
    private ArrayList<VariableBuilder> variables = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ValidatingAdmissionPolicySpecFluent() {
    }

    public ValidatingAdmissionPolicySpecFluent(ValidatingAdmissionPolicySpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ValidatingAdmissionPolicySpec instance) {
        ValidatingAdmissionPolicySpec validatingAdmissionPolicySpec = instance = instance != null ? instance : new ValidatingAdmissionPolicySpec();
        if (instance != null) {
            this.withAuditAnnotations(instance.getAuditAnnotations());
            this.withFailurePolicy(instance.getFailurePolicy());
            this.withMatchConditions(instance.getMatchConditions());
            this.withMatchConstraints(instance.getMatchConstraints());
            this.withParamKind(instance.getParamKind());
            this.withValidations(instance.getValidations());
            this.withVariables(instance.getVariables());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAuditAnnotations(int index, AuditAnnotation item) {
        if (this.auditAnnotations == null) {
            this.auditAnnotations = new ArrayList();
        }
        AuditAnnotationBuilder builder = new AuditAnnotationBuilder(item);
        if (index < 0 || index >= this.auditAnnotations.size()) {
            this._visitables.get("auditAnnotations").add(builder);
            this.auditAnnotations.add(builder);
        } else {
            this._visitables.get("auditAnnotations").add(index, builder);
            this.auditAnnotations.add(index, builder);
        }
        return (A)this;
    }

    public A setToAuditAnnotations(int index, AuditAnnotation item) {
        if (this.auditAnnotations == null) {
            this.auditAnnotations = new ArrayList();
        }
        AuditAnnotationBuilder builder = new AuditAnnotationBuilder(item);
        if (index < 0 || index >= this.auditAnnotations.size()) {
            this._visitables.get("auditAnnotations").add(builder);
            this.auditAnnotations.add(builder);
        } else {
            this._visitables.get("auditAnnotations").set(index, builder);
            this.auditAnnotations.set(index, builder);
        }
        return (A)this;
    }

    public A addToAuditAnnotations(AuditAnnotation ... items) {
        if (this.auditAnnotations == null) {
            this.auditAnnotations = new ArrayList();
        }
        for (AuditAnnotation item : items) {
            AuditAnnotationBuilder builder = new AuditAnnotationBuilder(item);
            this._visitables.get("auditAnnotations").add(builder);
            this.auditAnnotations.add(builder);
        }
        return (A)this;
    }

    public A addAllToAuditAnnotations(Collection<AuditAnnotation> items) {
        if (this.auditAnnotations == null) {
            this.auditAnnotations = new ArrayList();
        }
        for (AuditAnnotation item : items) {
            AuditAnnotationBuilder builder = new AuditAnnotationBuilder(item);
            this._visitables.get("auditAnnotations").add(builder);
            this.auditAnnotations.add(builder);
        }
        return (A)this;
    }

    public A removeFromAuditAnnotations(AuditAnnotation ... items) {
        if (this.auditAnnotations == null) {
            return (A)this;
        }
        for (AuditAnnotation item : items) {
            AuditAnnotationBuilder builder = new AuditAnnotationBuilder(item);
            this._visitables.get("auditAnnotations").remove(builder);
            this.auditAnnotations.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromAuditAnnotations(Collection<AuditAnnotation> items) {
        if (this.auditAnnotations == null) {
            return (A)this;
        }
        for (AuditAnnotation item : items) {
            AuditAnnotationBuilder builder = new AuditAnnotationBuilder(item);
            this._visitables.get("auditAnnotations").remove(builder);
            this.auditAnnotations.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromAuditAnnotations(Predicate<AuditAnnotationBuilder> predicate) {
        if (this.auditAnnotations == null) {
            return (A)this;
        }
        Iterator<AuditAnnotationBuilder> each = this.auditAnnotations.iterator();
        Object visitables = this._visitables.get("auditAnnotations");
        while (each.hasNext()) {
            AuditAnnotationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<AuditAnnotation> buildAuditAnnotations() {
        return this.auditAnnotations != null ? ValidatingAdmissionPolicySpecFluent.build(this.auditAnnotations) : null;
    }

    public AuditAnnotation buildAuditAnnotation(int index) {
        return this.auditAnnotations.get(index).build();
    }

    public AuditAnnotation buildFirstAuditAnnotation() {
        return this.auditAnnotations.get(0).build();
    }

    public AuditAnnotation buildLastAuditAnnotation() {
        return this.auditAnnotations.get(this.auditAnnotations.size() - 1).build();
    }

    public AuditAnnotation buildMatchingAuditAnnotation(Predicate<AuditAnnotationBuilder> predicate) {
        for (AuditAnnotationBuilder item : this.auditAnnotations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAuditAnnotation(Predicate<AuditAnnotationBuilder> predicate) {
        for (AuditAnnotationBuilder item : this.auditAnnotations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAuditAnnotations(List<AuditAnnotation> auditAnnotations) {
        if (this.auditAnnotations != null) {
            this._visitables.get("auditAnnotations").clear();
        }
        if (auditAnnotations != null) {
            this.auditAnnotations = new ArrayList();
            for (AuditAnnotation item : auditAnnotations) {
                this.addToAuditAnnotations(item);
            }
        } else {
            this.auditAnnotations = null;
        }
        return (A)this;
    }

    public A withAuditAnnotations(AuditAnnotation ... auditAnnotations) {
        if (this.auditAnnotations != null) {
            this.auditAnnotations.clear();
            this._visitables.remove("auditAnnotations");
        }
        if (auditAnnotations != null) {
            for (AuditAnnotation item : auditAnnotations) {
                this.addToAuditAnnotations(item);
            }
        }
        return (A)this;
    }

    public boolean hasAuditAnnotations() {
        return this.auditAnnotations != null && !this.auditAnnotations.isEmpty();
    }

    public A addNewAuditAnnotation(String key, String valueExpression) {
        return this.addToAuditAnnotations(new AuditAnnotation(key, valueExpression));
    }

    public AuditAnnotationsNested<A> addNewAuditAnnotation() {
        return new AuditAnnotationsNested(-1, null);
    }

    public AuditAnnotationsNested<A> addNewAuditAnnotationLike(AuditAnnotation item) {
        return new AuditAnnotationsNested(-1, item);
    }

    public AuditAnnotationsNested<A> setNewAuditAnnotationLike(int index, AuditAnnotation item) {
        return new AuditAnnotationsNested(index, item);
    }

    public AuditAnnotationsNested<A> editAuditAnnotation(int index) {
        if (this.auditAnnotations.size() <= index) {
            throw new RuntimeException("Can't edit auditAnnotations. Index exceeds size.");
        }
        return this.setNewAuditAnnotationLike(index, this.buildAuditAnnotation(index));
    }

    public AuditAnnotationsNested<A> editFirstAuditAnnotation() {
        if (this.auditAnnotations.size() == 0) {
            throw new RuntimeException("Can't edit first auditAnnotations. The list is empty.");
        }
        return this.setNewAuditAnnotationLike(0, this.buildAuditAnnotation(0));
    }

    public AuditAnnotationsNested<A> editLastAuditAnnotation() {
        int index = this.auditAnnotations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last auditAnnotations. The list is empty.");
        }
        return this.setNewAuditAnnotationLike(index, this.buildAuditAnnotation(index));
    }

    public AuditAnnotationsNested<A> editMatchingAuditAnnotation(Predicate<AuditAnnotationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.auditAnnotations.size(); ++i) {
            if (!predicate.test(this.auditAnnotations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching auditAnnotations. No match found.");
        }
        return this.setNewAuditAnnotationLike(index, this.buildAuditAnnotation(index));
    }

    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    public A withFailurePolicy(String failurePolicy) {
        this.failurePolicy = failurePolicy;
        return (A)this;
    }

    public boolean hasFailurePolicy() {
        return this.failurePolicy != null;
    }

    public A addToMatchConditions(int index, MatchCondition item) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        MatchConditionBuilder builder = new MatchConditionBuilder(item);
        if (index < 0 || index >= this.matchConditions.size()) {
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(builder);
        } else {
            this._visitables.get("matchConditions").add(index, builder);
            this.matchConditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToMatchConditions(int index, MatchCondition item) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        MatchConditionBuilder builder = new MatchConditionBuilder(item);
        if (index < 0 || index >= this.matchConditions.size()) {
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(builder);
        } else {
            this._visitables.get("matchConditions").set(index, builder);
            this.matchConditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToMatchConditions(MatchCondition ... items) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        for (MatchCondition item : items) {
            MatchConditionBuilder builder = new MatchConditionBuilder(item);
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToMatchConditions(Collection<MatchCondition> items) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        for (MatchCondition item : items) {
            MatchConditionBuilder builder = new MatchConditionBuilder(item);
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromMatchConditions(MatchCondition ... items) {
        if (this.matchConditions == null) {
            return (A)this;
        }
        for (MatchCondition item : items) {
            MatchConditionBuilder builder = new MatchConditionBuilder(item);
            this._visitables.get("matchConditions").remove(builder);
            this.matchConditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromMatchConditions(Collection<MatchCondition> items) {
        if (this.matchConditions == null) {
            return (A)this;
        }
        for (MatchCondition item : items) {
            MatchConditionBuilder builder = new MatchConditionBuilder(item);
            this._visitables.get("matchConditions").remove(builder);
            this.matchConditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromMatchConditions(Predicate<MatchConditionBuilder> predicate) {
        if (this.matchConditions == null) {
            return (A)this;
        }
        Iterator<MatchConditionBuilder> each = this.matchConditions.iterator();
        Object visitables = this._visitables.get("matchConditions");
        while (each.hasNext()) {
            MatchConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<MatchCondition> buildMatchConditions() {
        return this.matchConditions != null ? ValidatingAdmissionPolicySpecFluent.build(this.matchConditions) : null;
    }

    public MatchCondition buildMatchCondition(int index) {
        return this.matchConditions.get(index).build();
    }

    public MatchCondition buildFirstMatchCondition() {
        return this.matchConditions.get(0).build();
    }

    public MatchCondition buildLastMatchCondition() {
        return this.matchConditions.get(this.matchConditions.size() - 1).build();
    }

    public MatchCondition buildMatchingMatchCondition(Predicate<MatchConditionBuilder> predicate) {
        for (MatchConditionBuilder item : this.matchConditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMatchCondition(Predicate<MatchConditionBuilder> predicate) {
        for (MatchConditionBuilder item : this.matchConditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatchConditions(List<MatchCondition> matchConditions) {
        if (this.matchConditions != null) {
            this._visitables.get("matchConditions").clear();
        }
        if (matchConditions != null) {
            this.matchConditions = new ArrayList();
            for (MatchCondition item : matchConditions) {
                this.addToMatchConditions(item);
            }
        } else {
            this.matchConditions = null;
        }
        return (A)this;
    }

    public A withMatchConditions(MatchCondition ... matchConditions) {
        if (this.matchConditions != null) {
            this.matchConditions.clear();
            this._visitables.remove("matchConditions");
        }
        if (matchConditions != null) {
            for (MatchCondition item : matchConditions) {
                this.addToMatchConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasMatchConditions() {
        return this.matchConditions != null && !this.matchConditions.isEmpty();
    }

    public A addNewMatchCondition(String expression, String name) {
        return this.addToMatchConditions(new MatchCondition(expression, name));
    }

    public MatchConditionsNested<A> addNewMatchCondition() {
        return new MatchConditionsNested(-1, null);
    }

    public MatchConditionsNested<A> addNewMatchConditionLike(MatchCondition item) {
        return new MatchConditionsNested(-1, item);
    }

    public MatchConditionsNested<A> setNewMatchConditionLike(int index, MatchCondition item) {
        return new MatchConditionsNested(index, item);
    }

    public MatchConditionsNested<A> editMatchCondition(int index) {
        if (this.matchConditions.size() <= index) {
            throw new RuntimeException("Can't edit matchConditions. Index exceeds size.");
        }
        return this.setNewMatchConditionLike(index, this.buildMatchCondition(index));
    }

    public MatchConditionsNested<A> editFirstMatchCondition() {
        if (this.matchConditions.size() == 0) {
            throw new RuntimeException("Can't edit first matchConditions. The list is empty.");
        }
        return this.setNewMatchConditionLike(0, this.buildMatchCondition(0));
    }

    public MatchConditionsNested<A> editLastMatchCondition() {
        int index = this.matchConditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matchConditions. The list is empty.");
        }
        return this.setNewMatchConditionLike(index, this.buildMatchCondition(index));
    }

    public MatchConditionsNested<A> editMatchingMatchCondition(Predicate<MatchConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchConditions.size(); ++i) {
            if (!predicate.test(this.matchConditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matchConditions. No match found.");
        }
        return this.setNewMatchConditionLike(index, this.buildMatchCondition(index));
    }

    public MatchResources buildMatchConstraints() {
        return this.matchConstraints != null ? this.matchConstraints.build() : null;
    }

    public A withMatchConstraints(MatchResources matchConstraints) {
        this._visitables.remove("matchConstraints");
        if (matchConstraints != null) {
            this.matchConstraints = new MatchResourcesBuilder(matchConstraints);
            this._visitables.get("matchConstraints").add(this.matchConstraints);
        } else {
            this.matchConstraints = null;
            this._visitables.get("matchConstraints").remove(this.matchConstraints);
        }
        return (A)this;
    }

    public boolean hasMatchConstraints() {
        return this.matchConstraints != null;
    }

    public MatchConstraintsNested<A> withNewMatchConstraints() {
        return new MatchConstraintsNested(null);
    }

    public MatchConstraintsNested<A> withNewMatchConstraintsLike(MatchResources item) {
        return new MatchConstraintsNested(item);
    }

    public MatchConstraintsNested<A> editMatchConstraints() {
        return this.withNewMatchConstraintsLike(Optional.ofNullable(this.buildMatchConstraints()).orElse(null));
    }

    public MatchConstraintsNested<A> editOrNewMatchConstraints() {
        return this.withNewMatchConstraintsLike(Optional.ofNullable(this.buildMatchConstraints()).orElse(new MatchResourcesBuilder().build()));
    }

    public MatchConstraintsNested<A> editOrNewMatchConstraintsLike(MatchResources item) {
        return this.withNewMatchConstraintsLike(Optional.ofNullable(this.buildMatchConstraints()).orElse(item));
    }

    public ParamKind buildParamKind() {
        return this.paramKind != null ? this.paramKind.build() : null;
    }

    public A withParamKind(ParamKind paramKind) {
        this._visitables.remove("paramKind");
        if (paramKind != null) {
            this.paramKind = new ParamKindBuilder(paramKind);
            this._visitables.get("paramKind").add(this.paramKind);
        } else {
            this.paramKind = null;
            this._visitables.get("paramKind").remove(this.paramKind);
        }
        return (A)this;
    }

    public boolean hasParamKind() {
        return this.paramKind != null;
    }

    public A withNewParamKind(String apiVersion, String kind) {
        return this.withParamKind(new ParamKind(apiVersion, kind));
    }

    public ParamKindNested<A> withNewParamKind() {
        return new ParamKindNested(null);
    }

    public ParamKindNested<A> withNewParamKindLike(ParamKind item) {
        return new ParamKindNested(item);
    }

    public ParamKindNested<A> editParamKind() {
        return this.withNewParamKindLike(Optional.ofNullable(this.buildParamKind()).orElse(null));
    }

    public ParamKindNested<A> editOrNewParamKind() {
        return this.withNewParamKindLike(Optional.ofNullable(this.buildParamKind()).orElse(new ParamKindBuilder().build()));
    }

    public ParamKindNested<A> editOrNewParamKindLike(ParamKind item) {
        return this.withNewParamKindLike(Optional.ofNullable(this.buildParamKind()).orElse(item));
    }

    public A addToValidations(int index, Validation item) {
        if (this.validations == null) {
            this.validations = new ArrayList();
        }
        ValidationBuilder builder = new ValidationBuilder(item);
        if (index < 0 || index >= this.validations.size()) {
            this._visitables.get("validations").add(builder);
            this.validations.add(builder);
        } else {
            this._visitables.get("validations").add(index, builder);
            this.validations.add(index, builder);
        }
        return (A)this;
    }

    public A setToValidations(int index, Validation item) {
        if (this.validations == null) {
            this.validations = new ArrayList();
        }
        ValidationBuilder builder = new ValidationBuilder(item);
        if (index < 0 || index >= this.validations.size()) {
            this._visitables.get("validations").add(builder);
            this.validations.add(builder);
        } else {
            this._visitables.get("validations").set(index, builder);
            this.validations.set(index, builder);
        }
        return (A)this;
    }

    public A addToValidations(Validation ... items) {
        if (this.validations == null) {
            this.validations = new ArrayList();
        }
        for (Validation item : items) {
            ValidationBuilder builder = new ValidationBuilder(item);
            this._visitables.get("validations").add(builder);
            this.validations.add(builder);
        }
        return (A)this;
    }

    public A addAllToValidations(Collection<Validation> items) {
        if (this.validations == null) {
            this.validations = new ArrayList();
        }
        for (Validation item : items) {
            ValidationBuilder builder = new ValidationBuilder(item);
            this._visitables.get("validations").add(builder);
            this.validations.add(builder);
        }
        return (A)this;
    }

    public A removeFromValidations(Validation ... items) {
        if (this.validations == null) {
            return (A)this;
        }
        for (Validation item : items) {
            ValidationBuilder builder = new ValidationBuilder(item);
            this._visitables.get("validations").remove(builder);
            this.validations.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromValidations(Collection<Validation> items) {
        if (this.validations == null) {
            return (A)this;
        }
        for (Validation item : items) {
            ValidationBuilder builder = new ValidationBuilder(item);
            this._visitables.get("validations").remove(builder);
            this.validations.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromValidations(Predicate<ValidationBuilder> predicate) {
        if (this.validations == null) {
            return (A)this;
        }
        Iterator<ValidationBuilder> each = this.validations.iterator();
        Object visitables = this._visitables.get("validations");
        while (each.hasNext()) {
            ValidationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Validation> buildValidations() {
        return this.validations != null ? ValidatingAdmissionPolicySpecFluent.build(this.validations) : null;
    }

    public Validation buildValidation(int index) {
        return this.validations.get(index).build();
    }

    public Validation buildFirstValidation() {
        return this.validations.get(0).build();
    }

    public Validation buildLastValidation() {
        return this.validations.get(this.validations.size() - 1).build();
    }

    public Validation buildMatchingValidation(Predicate<ValidationBuilder> predicate) {
        for (ValidationBuilder item : this.validations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingValidation(Predicate<ValidationBuilder> predicate) {
        for (ValidationBuilder item : this.validations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withValidations(List<Validation> validations) {
        if (this.validations != null) {
            this._visitables.get("validations").clear();
        }
        if (validations != null) {
            this.validations = new ArrayList();
            for (Validation item : validations) {
                this.addToValidations(item);
            }
        } else {
            this.validations = null;
        }
        return (A)this;
    }

    public A withValidations(Validation ... validations) {
        if (this.validations != null) {
            this.validations.clear();
            this._visitables.remove("validations");
        }
        if (validations != null) {
            for (Validation item : validations) {
                this.addToValidations(item);
            }
        }
        return (A)this;
    }

    public boolean hasValidations() {
        return this.validations != null && !this.validations.isEmpty();
    }

    public A addNewValidation(String expression, String message, String messageExpression, String reason) {
        return this.addToValidations(new Validation(expression, message, messageExpression, reason));
    }

    public ValidationsNested<A> addNewValidation() {
        return new ValidationsNested(-1, null);
    }

    public ValidationsNested<A> addNewValidationLike(Validation item) {
        return new ValidationsNested(-1, item);
    }

    public ValidationsNested<A> setNewValidationLike(int index, Validation item) {
        return new ValidationsNested(index, item);
    }

    public ValidationsNested<A> editValidation(int index) {
        if (this.validations.size() <= index) {
            throw new RuntimeException("Can't edit validations. Index exceeds size.");
        }
        return this.setNewValidationLike(index, this.buildValidation(index));
    }

    public ValidationsNested<A> editFirstValidation() {
        if (this.validations.size() == 0) {
            throw new RuntimeException("Can't edit first validations. The list is empty.");
        }
        return this.setNewValidationLike(0, this.buildValidation(0));
    }

    public ValidationsNested<A> editLastValidation() {
        int index = this.validations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last validations. The list is empty.");
        }
        return this.setNewValidationLike(index, this.buildValidation(index));
    }

    public ValidationsNested<A> editMatchingValidation(Predicate<ValidationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.validations.size(); ++i) {
            if (!predicate.test(this.validations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching validations. No match found.");
        }
        return this.setNewValidationLike(index, this.buildValidation(index));
    }

    public A addToVariables(int index, Variable item) {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        VariableBuilder builder = new VariableBuilder(item);
        if (index < 0 || index >= this.variables.size()) {
            this._visitables.get("variables").add(builder);
            this.variables.add(builder);
        } else {
            this._visitables.get("variables").add(index, builder);
            this.variables.add(index, builder);
        }
        return (A)this;
    }

    public A setToVariables(int index, Variable item) {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        VariableBuilder builder = new VariableBuilder(item);
        if (index < 0 || index >= this.variables.size()) {
            this._visitables.get("variables").add(builder);
            this.variables.add(builder);
        } else {
            this._visitables.get("variables").set(index, builder);
            this.variables.set(index, builder);
        }
        return (A)this;
    }

    public A addToVariables(Variable ... items) {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        for (Variable item : items) {
            VariableBuilder builder = new VariableBuilder(item);
            this._visitables.get("variables").add(builder);
            this.variables.add(builder);
        }
        return (A)this;
    }

    public A addAllToVariables(Collection<Variable> items) {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        for (Variable item : items) {
            VariableBuilder builder = new VariableBuilder(item);
            this._visitables.get("variables").add(builder);
            this.variables.add(builder);
        }
        return (A)this;
    }

    public A removeFromVariables(Variable ... items) {
        if (this.variables == null) {
            return (A)this;
        }
        for (Variable item : items) {
            VariableBuilder builder = new VariableBuilder(item);
            this._visitables.get("variables").remove(builder);
            this.variables.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromVariables(Collection<Variable> items) {
        if (this.variables == null) {
            return (A)this;
        }
        for (Variable item : items) {
            VariableBuilder builder = new VariableBuilder(item);
            this._visitables.get("variables").remove(builder);
            this.variables.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromVariables(Predicate<VariableBuilder> predicate) {
        if (this.variables == null) {
            return (A)this;
        }
        Iterator<VariableBuilder> each = this.variables.iterator();
        Object visitables = this._visitables.get("variables");
        while (each.hasNext()) {
            VariableBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Variable> buildVariables() {
        return this.variables != null ? ValidatingAdmissionPolicySpecFluent.build(this.variables) : null;
    }

    public Variable buildVariable(int index) {
        return this.variables.get(index).build();
    }

    public Variable buildFirstVariable() {
        return this.variables.get(0).build();
    }

    public Variable buildLastVariable() {
        return this.variables.get(this.variables.size() - 1).build();
    }

    public Variable buildMatchingVariable(Predicate<VariableBuilder> predicate) {
        for (VariableBuilder item : this.variables) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVariable(Predicate<VariableBuilder> predicate) {
        for (VariableBuilder item : this.variables) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVariables(List<Variable> variables) {
        if (this.variables != null) {
            this._visitables.get("variables").clear();
        }
        if (variables != null) {
            this.variables = new ArrayList();
            for (Variable item : variables) {
                this.addToVariables(item);
            }
        } else {
            this.variables = null;
        }
        return (A)this;
    }

    public A withVariables(Variable ... variables) {
        if (this.variables != null) {
            this.variables.clear();
            this._visitables.remove("variables");
        }
        if (variables != null) {
            for (Variable item : variables) {
                this.addToVariables(item);
            }
        }
        return (A)this;
    }

    public boolean hasVariables() {
        return this.variables != null && !this.variables.isEmpty();
    }

    public A addNewVariable(String expression, String name) {
        return this.addToVariables(new Variable(expression, name));
    }

    public VariablesNested<A> addNewVariable() {
        return new VariablesNested(-1, null);
    }

    public VariablesNested<A> addNewVariableLike(Variable item) {
        return new VariablesNested(-1, item);
    }

    public VariablesNested<A> setNewVariableLike(int index, Variable item) {
        return new VariablesNested(index, item);
    }

    public VariablesNested<A> editVariable(int index) {
        if (this.variables.size() <= index) {
            throw new RuntimeException("Can't edit variables. Index exceeds size.");
        }
        return this.setNewVariableLike(index, this.buildVariable(index));
    }

    public VariablesNested<A> editFirstVariable() {
        if (this.variables.size() == 0) {
            throw new RuntimeException("Can't edit first variables. The list is empty.");
        }
        return this.setNewVariableLike(0, this.buildVariable(0));
    }

    public VariablesNested<A> editLastVariable() {
        int index = this.variables.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last variables. The list is empty.");
        }
        return this.setNewVariableLike(index, this.buildVariable(index));
    }

    public VariablesNested<A> editMatchingVariable(Predicate<VariableBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.variables.size(); ++i) {
            if (!predicate.test(this.variables.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching variables. No match found.");
        }
        return this.setNewVariableLike(index, this.buildVariable(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ValidatingAdmissionPolicySpecFluent that = (ValidatingAdmissionPolicySpecFluent)o;
        if (!Objects.equals(this.auditAnnotations, that.auditAnnotations)) {
            return false;
        }
        if (!Objects.equals(this.failurePolicy, that.failurePolicy)) {
            return false;
        }
        if (!Objects.equals(this.matchConditions, that.matchConditions)) {
            return false;
        }
        if (!Objects.equals(this.matchConstraints, that.matchConstraints)) {
            return false;
        }
        if (!Objects.equals(this.paramKind, that.paramKind)) {
            return false;
        }
        if (!Objects.equals(this.validations, that.validations)) {
            return false;
        }
        if (!Objects.equals(this.variables, that.variables)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.auditAnnotations, this.failurePolicy, this.matchConditions, this.matchConstraints, this.paramKind, this.validations, this.variables, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.auditAnnotations != null && !this.auditAnnotations.isEmpty()) {
            sb.append("auditAnnotations:");
            sb.append(this.auditAnnotations + ",");
        }
        if (this.failurePolicy != null) {
            sb.append("failurePolicy:");
            sb.append(this.failurePolicy + ",");
        }
        if (this.matchConditions != null && !this.matchConditions.isEmpty()) {
            sb.append("matchConditions:");
            sb.append(this.matchConditions + ",");
        }
        if (this.matchConstraints != null) {
            sb.append("matchConstraints:");
            sb.append(this.matchConstraints + ",");
        }
        if (this.paramKind != null) {
            sb.append("paramKind:");
            sb.append(this.paramKind + ",");
        }
        if (this.validations != null && !this.validations.isEmpty()) {
            sb.append("validations:");
            sb.append(this.validations + ",");
        }
        if (this.variables != null && !this.variables.isEmpty()) {
            sb.append("variables:");
            sb.append(this.variables + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class VariablesNested<N>
    extends VariableFluent<VariablesNested<N>>
    implements Nested<N> {
        VariableBuilder builder;
        int index;

        VariablesNested(int index, Variable item) {
            this.index = index;
            this.builder = new VariableBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ValidatingAdmissionPolicySpecFluent.this.setToVariables(this.index, this.builder.build());
        }

        public N endVariable() {
            return this.and();
        }
    }

    public class ValidationsNested<N>
    extends ValidationFluent<ValidationsNested<N>>
    implements Nested<N> {
        ValidationBuilder builder;
        int index;

        ValidationsNested(int index, Validation item) {
            this.index = index;
            this.builder = new ValidationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ValidatingAdmissionPolicySpecFluent.this.setToValidations(this.index, this.builder.build());
        }

        public N endValidation() {
            return this.and();
        }
    }

    public class ParamKindNested<N>
    extends ParamKindFluent<ParamKindNested<N>>
    implements Nested<N> {
        ParamKindBuilder builder;

        ParamKindNested(ParamKind item) {
            this.builder = new ParamKindBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ValidatingAdmissionPolicySpecFluent.this.withParamKind(this.builder.build());
        }

        public N endParamKind() {
            return this.and();
        }
    }

    public class MatchConstraintsNested<N>
    extends MatchResourcesFluent<MatchConstraintsNested<N>>
    implements Nested<N> {
        MatchResourcesBuilder builder;

        MatchConstraintsNested(MatchResources item) {
            this.builder = new MatchResourcesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ValidatingAdmissionPolicySpecFluent.this.withMatchConstraints(this.builder.build());
        }

        public N endMatchConstraints() {
            return this.and();
        }
    }

    public class MatchConditionsNested<N>
    extends MatchConditionFluent<MatchConditionsNested<N>>
    implements Nested<N> {
        MatchConditionBuilder builder;
        int index;

        MatchConditionsNested(int index, MatchCondition item) {
            this.index = index;
            this.builder = new MatchConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ValidatingAdmissionPolicySpecFluent.this.setToMatchConditions(this.index, this.builder.build());
        }

        public N endMatchCondition() {
            return this.and();
        }
    }

    public class AuditAnnotationsNested<N>
    extends AuditAnnotationFluent<AuditAnnotationsNested<N>>
    implements Nested<N> {
        AuditAnnotationBuilder builder;
        int index;

        AuditAnnotationsNested(int index, AuditAnnotation item) {
            this.index = index;
            this.builder = new AuditAnnotationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ValidatingAdmissionPolicySpecFluent.this.setToAuditAnnotations(this.index, this.builder.build());
        }

        public N endAuditAnnotation() {
            return this.and();
        }
    }
}

