/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.decorators;

import java.util.List;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesTaskManagerParameters;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Container;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EnvVarBuilder;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.util.Preconditions;

public class CmdTaskManagerDecorator
extends AbstractKubernetesStepDecorator {
    private final KubernetesTaskManagerParameters kubernetesTaskManagerParameters;

    public CmdTaskManagerDecorator(KubernetesTaskManagerParameters kubernetesTaskManagerParameters) {
        this.kubernetesTaskManagerParameters = (KubernetesTaskManagerParameters)Preconditions.checkNotNull((Object)kubernetesTaskManagerParameters);
    }

    @Override
    public FlinkPod decorateFlinkPod(FlinkPod flinkPod) {
        Container mainContainerWithStartCmd = ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder(flinkPod.getMainContainer()).withCommand(this.kubernetesTaskManagerParameters.getContainerEntrypoint())).withArgs(this.getTaskManagerStartCommand())).addToEnv(((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("FLINK_TM_JVM_MEM_OPTS")).withValue(this.kubernetesTaskManagerParameters.getJvmMemOptsEnv())).build())).build();
        return new FlinkPod.Builder(flinkPod).withMainContainer(mainContainerWithStartCmd).build();
    }

    private List<String> getTaskManagerStartCommand() {
        String resourceArgs = TaskExecutorProcessUtils.generateDynamicConfigsStr((TaskExecutorProcessSpec)this.kubernetesTaskManagerParameters.getContaineredTaskManagerParameters().getTaskExecutorProcessSpec());
        String dynamicProperties = this.kubernetesTaskManagerParameters.getDynamicProperties();
        return KubernetesUtils.getStartCommandWithBashWrapper("kubernetes-taskmanager.sh " + dynamicProperties + " " + resourceArgs + " " + this.kubernetesTaskManagerParameters.getEntrypointArgs());
    }
}

