/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.entrypoint;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpecFactory;

public class KubernetesWorkerResourceSpecFactory
extends WorkerResourceSpecFactory {
    public static final KubernetesWorkerResourceSpecFactory INSTANCE = new KubernetesWorkerResourceSpecFactory();

    private KubernetesWorkerResourceSpecFactory() {
    }

    public WorkerResourceSpec createDefaultWorkerResourceSpec(Configuration configuration) {
        return this.workerResourceSpecFromConfigAndCpu(configuration, KubernetesWorkerResourceSpecFactory.getDefaultCpus(configuration));
    }

    @VisibleForTesting
    static CPUResource getDefaultCpus(Configuration configuration) {
        double fallback = (Double)configuration.get(KubernetesConfigOptions.TASK_MANAGER_CPU);
        return TaskExecutorProcessUtils.getCpuCoresWithFallback((Configuration)configuration, (double)fallback);
    }
}

