/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.entrypoint;

import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.runtime.jobmanager.HighAvailabilityMode;
import org.apache.flink.util.Preconditions;

class KubernetesEntrypointUtils {
    static Configuration loadConfiguration(Configuration dynamicParameters) {
        String configDir = System.getenv("FLINK_CONF_DIR");
        Preconditions.checkNotNull((Object)configDir, (String)"Flink configuration directory (%s) in environment should not be null!", (Object[])new Object[]{"FLINK_CONF_DIR"});
        Configuration configuration = GlobalConfiguration.loadConfiguration((String)configDir, (Configuration)dynamicParameters);
        if (KubernetesUtils.isHostNetwork(configuration)) {
            configuration.set(RestOptions.BIND_PORT, (Object)"0");
            configuration.set(JobManagerOptions.PORT, (Object)0);
            configuration.set(BlobServerOptions.PORT, (Object)"0");
            configuration.set(HighAvailabilityOptions.HA_JOB_MANAGER_PORT_RANGE, (Object)"0");
            configuration.set(TaskManagerOptions.RPC_PORT, (Object)"0");
        }
        if (HighAvailabilityMode.isHighAvailabilityModeActivated((Configuration)configuration)) {
            String ipAddress = System.getenv().get("_POD_IP_ADDRESS");
            Preconditions.checkState((ipAddress != null ? 1 : 0) != 0, (String)"JobManager ip address environment variable %s not set", (Object[])new Object[]{"_POD_IP_ADDRESS"});
            configuration.set(JobManagerOptions.ADDRESS, (Object)ipAddress);
            configuration.set(RestOptions.ADDRESS, (Object)ipAddress);
        }
        return configuration;
    }

    private KubernetesEntrypointUtils() {
    }
}

