/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.decorators;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.AbstractKubernetesParameters;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ConfigMapFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HasMetadata;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KeyToPathBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodSpecFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.SecretBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.SecretFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.VolumeFluent;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.shaded.guava31.com.google.common.io.Files;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosMountDecorator
extends AbstractKubernetesStepDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosMountDecorator.class);
    private final AbstractKubernetesParameters kubernetesParameters;
    private final SecurityConfiguration securityConfig;

    public KerberosMountDecorator(AbstractKubernetesParameters kubernetesParameters) {
        this.kubernetesParameters = (AbstractKubernetesParameters)Preconditions.checkNotNull((Object)kubernetesParameters);
        this.securityConfig = new SecurityConfiguration(kubernetesParameters.getFlinkConfiguration());
    }

    @Override
    public FlinkPod decorateFlinkPod(FlinkPod flinkPod) {
        PodBuilder podBuilder = new PodBuilder(flinkPod.getPodWithoutMainContainer());
        ContainerBuilder containerBuilder = new ContainerBuilder(flinkPod.getMainContainer());
        if (!StringUtils.isNullOrWhitespaceOnly((String)this.securityConfig.getKeytab()) && !StringUtils.isNullOrWhitespaceOnly((String)this.securityConfig.getPrincipal())) {
            podBuilder = (PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.SecretNested)((PodSpecFluent.VolumesNested)podBuilder.editOrNewSpec().addNewVolume().withName("kerberos-keytab-volume")).withNewSecret().withSecretName(KerberosMountDecorator.getKerberosKeytabSecretName(this.kubernetesParameters.getClusterId()))).endSecret()).endVolume()).endSpec();
            containerBuilder = (ContainerBuilder)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)containerBuilder.addNewVolumeMount().withName("kerberos-keytab-volume")).withMountPath("/opt/kerberos/kerberos-keytab")).endVolumeMount();
        }
        if (!StringUtils.isNullOrWhitespaceOnly((String)((String)this.kubernetesParameters.getFlinkConfiguration().get(SecurityOptions.KERBEROS_KRB5_PATH)))) {
            File krb5Conf = new File((String)this.kubernetesParameters.getFlinkConfiguration().get(SecurityOptions.KERBEROS_KRB5_PATH));
            podBuilder = (PodBuilder)((PodFluent.SpecNested)((PodSpecFluent.VolumesNested)((VolumeFluent.ConfigMapNested)((VolumeFluent.ConfigMapNested)((PodSpecFluent.VolumesNested)podBuilder.editOrNewSpec().addNewVolume().withName("kerberos-krb5conf-volume")).withNewConfigMap().withName(KerberosMountDecorator.getKerberosKrb5confConfigMapName(this.kubernetesParameters.getClusterId()))).withItems(((KeyToPathBuilder)((KeyToPathBuilder)new KeyToPathBuilder().withKey(krb5Conf.getName())).withPath("krb5.conf")).build())).endConfigMap()).endVolume()).endSpec();
            containerBuilder = (ContainerBuilder)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)containerBuilder.addNewVolumeMount().withName("kerberos-krb5conf-volume")).withMountPath("/etc/krb5.conf")).withSubPath("krb5.conf")).endVolumeMount();
        }
        return new FlinkPod(podBuilder.build(), containerBuilder.build());
    }

    @Override
    public List<HasMetadata> buildAccompanyingKubernetesResources() throws IOException {
        ArrayList<HasMetadata> resources = new ArrayList<HasMetadata>();
        if (!StringUtils.isNullOrWhitespaceOnly((String)this.securityConfig.getKeytab()) && !StringUtils.isNullOrWhitespaceOnly((String)this.securityConfig.getPrincipal())) {
            File keytab = new File(this.securityConfig.getKeytab());
            if (!keytab.exists()) {
                LOG.warn("Could not found the kerberos keytab file in {}.", (Object)keytab.getAbsolutePath());
            } else {
                resources.add(((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName(KerberosMountDecorator.getKerberosKeytabSecretName(this.kubernetesParameters.getClusterId()))).endMetadata()).addToData(keytab.getName(), Base64.getEncoder().encodeToString(Files.toByteArray((File)keytab)))).build());
                this.kubernetesParameters.getFlinkConfiguration().set(SecurityOptions.KERBEROS_LOGIN_KEYTAB, (Object)String.format("%s/%s", "/opt/kerberos/kerberos-keytab", keytab.getName()));
            }
        }
        if (!StringUtils.isNullOrWhitespaceOnly((String)((String)this.kubernetesParameters.getFlinkConfiguration().get(SecurityOptions.KERBEROS_KRB5_PATH)))) {
            File krb5Conf = new File((String)this.kubernetesParameters.getFlinkConfiguration().get(SecurityOptions.KERBEROS_KRB5_PATH));
            if (!krb5Conf.exists()) {
                LOG.warn("Could not found the kerberos config file in {}.", (Object)krb5Conf.getAbsolutePath());
            } else {
                resources.add(((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(KerberosMountDecorator.getKerberosKrb5confConfigMapName(this.kubernetesParameters.getClusterId()))).endMetadata()).addToData(krb5Conf.getName(), Files.toString((File)krb5Conf, (Charset)StandardCharsets.UTF_8))).build());
            }
        }
        return resources;
    }

    public static String getKerberosKeytabSecretName(String clusterId) {
        return "kerberos-keytab-" + clusterId;
    }

    public static String getKerberosKrb5confConfigMapName(String clusterID) {
        return "kerberos-krb5conf-" + clusterID;
    }
}

