/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.highavailability;

import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.execution.RestoreMode;
import org.apache.flink.kubernetes.highavailability.KubernetesCheckpointIDCounter;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.state.SharedStateRegistryFactory;
import org.apache.flink.util.Preconditions;

public class KubernetesCheckpointRecoveryFactory
implements CheckpointRecoveryFactory {
    private final FlinkKubeClient kubeClient;
    private final Executor executor;
    private final Function<JobID, String> getConfigMapNameFunction;
    private final Configuration configuration;
    @Nullable
    private final String lockIdentity;
    private final String clusterId;

    private KubernetesCheckpointRecoveryFactory(FlinkKubeClient kubeClient, Configuration configuration, Executor executor, Function<JobID, String> function, String clusterId, @Nullable String lockIdentity) {
        this.kubeClient = (FlinkKubeClient)Preconditions.checkNotNull((Object)kubeClient);
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.getConfigMapNameFunction = (Function)Preconditions.checkNotNull(function);
        this.lockIdentity = lockIdentity;
        this.clusterId = clusterId;
    }

    public CompletedCheckpointStore createRecoveredCompletedCheckpointStore(JobID jobID, int maxNumberOfCheckpointsToRetain, SharedStateRegistryFactory sharedStateRegistryFactory, Executor ioExecutor, RestoreMode restoreMode) throws Exception {
        String configMapName = this.getConfigMapNameFunction.apply(jobID);
        KubernetesUtils.createConfigMapIfItDoesNotExist(this.kubeClient, configMapName, this.clusterId);
        return KubernetesUtils.createCompletedCheckpointStore(this.configuration, this.kubeClient, this.executor, configMapName, this.lockIdentity, maxNumberOfCheckpointsToRetain, sharedStateRegistryFactory, ioExecutor, restoreMode);
    }

    public CheckpointIDCounter createCheckpointIDCounter(JobID jobID) throws Exception {
        String configMapName = this.getConfigMapNameFunction.apply(jobID);
        KubernetesUtils.createConfigMapIfItDoesNotExist(this.kubeClient, configMapName, this.clusterId);
        return new KubernetesCheckpointIDCounter(this.kubeClient, configMapName, this.lockIdentity);
    }

    public static KubernetesCheckpointRecoveryFactory withLeadershipValidation(FlinkKubeClient kubeClient, Configuration configuration, Executor executor, String clusterId, Function<JobID, String> function, String lockIdentity) {
        return new KubernetesCheckpointRecoveryFactory(kubeClient, configuration, executor, function, clusterId, lockIdentity);
    }

    public static KubernetesCheckpointRecoveryFactory withoutLeadershipValidation(FlinkKubeClient kubeClient, Configuration configuration, Executor executor, String clusterId, Function<JobID, String> function) {
        return new KubernetesCheckpointRecoveryFactory(kubeClient, configuration, executor, function, clusterId, null);
    }
}

