/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.impl.cache;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.informers.impl.cache.ProcessorListener;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.internal.SerialExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedProcessor<T> {
    private static final Logger log = LoggerFactory.getLogger(SharedProcessor.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final List<ProcessorListener<T>> listeners = new ArrayList<ProcessorListener<T>>();
    private final List<ProcessorListener<T>> syncingListeners = new ArrayList<ProcessorListener<T>>();
    private final SerialExecutor executor;
    private final String informerDescription;

    public SharedProcessor() {
        this(Runnable::run, "informer");
    }

    public SharedProcessor(Executor executor, String informerDescription) {
        this.executor = new SerialExecutor(executor);
        this.informerDescription = informerDescription;
    }

    public void addListener(ProcessorListener<T> processorListener) {
        this.lock.writeLock().lock();
        try {
            this.listeners.add(processorListener);
            if (processorListener.isReSync()) {
                this.syncingListeners.add(processorListener);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void distribute(ProcessorListener.Notification<T> obj, boolean isSync) {
        this.distribute((ProcessorListener<T> l) -> l.add(obj), isSync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void distribute(Consumer<ProcessorListener<T>> operation, boolean isSync) {
        ArrayList<ProcessorListener<T>> toCall;
        this.lock.readLock().lock();
        try {
            toCall = isSync ? new ArrayList<ProcessorListener<T>>(this.syncingListeners) : new ArrayList<ProcessorListener<T>>(this.listeners);
        }
        finally {
            this.lock.readLock().unlock();
        }
        try {
            this.executor.execute(() -> {
                for (ProcessorListener listener : toCall) {
                    try {
                        operation.accept(listener);
                    }
                    catch (Exception ex) {
                        log.error("{} failed invoking {} event handler: {}", new Object[]{this.informerDescription, listener.getHandler(), ex.getMessage(), ex});
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldResync() {
        this.lock.writeLock().lock();
        boolean resyncNeeded = false;
        try {
            this.syncingListeners.clear();
            ZonedDateTime now = ZonedDateTime.now();
            for (ProcessorListener<T> listener : this.listeners) {
                if (!listener.shouldResync(now)) continue;
                resyncNeeded = true;
                this.syncingListeners.add(listener);
                listener.determineNextResync(now);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return resyncNeeded;
    }

    public void stop() {
        this.executor.shutdownNow();
        this.lock.writeLock().lock();
        try {
            this.syncingListeners.clear();
            this.listeners.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessorListener<T> addProcessorListener(ResourceEventHandler<? super T> handler, long resyncPeriodMillis, Supplier<Collection<T>> initialItems) {
        this.lock.writeLock().lock();
        try {
            ProcessorListener<T> listener = new ProcessorListener<T>(handler, resyncPeriodMillis);
            for (T item : initialItems.get()) {
                listener.add(new ProcessorListener.AddNotification<T>(item));
            }
            this.addListener(listener);
            ProcessorListener<T> processorListener = listener;
            return processorListener;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

